/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.street.model.edge;

import java.util.Optional;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.impl.PackedCoordinateSequence;
import org.opentripplanner.routing.util.ElevationUtils;
import org.opentripplanner.routing.util.SlopeCosts;
import org.opentripplanner.street.model.StreetTraversalPermission;
import org.opentripplanner.street.model.edge.StreetEdge;
import org.opentripplanner.street.model.edge.StreetEdgeBuilder;
import org.opentripplanner.street.model.edge.StreetElevationExtension;

public class StreetElevationExtensionBuilder {
    private StreetTraversalPermission permission;
    private PackedCoordinateSequence elevationProfile;
    private float bicycleSafetyFactor;
    private double distanceInMeters;
    private float walkSafetyFactor;
    private boolean isStairs;
    private boolean computed;
    private boolean isSlopeOverride;

    public static StreetElevationExtensionBuilder of(StreetEdge streetEdge) {
        return new StreetElevationExtensionBuilder().withComputed(true).withDistanceInMeters(streetEdge.getDistanceMeters()).withSlopeOverride(streetEdge.isSlopeOverride()).withStairs(streetEdge.isStairs()).withWalkSafetyFactor(streetEdge.getWalkSafetyFactor()).withBicycleSafetyFactor(streetEdge.getBicycleSafetyFactor()).withPermission(streetEdge.getPermission());
    }

    public static StreetElevationExtensionBuilder of(StreetEdgeBuilder<?> seb) {
        return new StreetElevationExtensionBuilder().withComputed(true).withSlopeOverride(seb.slopeOverride()).withStairs(seb.stairs()).withWalkSafetyFactor(seb.walkSafetyFactor()).withBicycleSafetyFactor(seb.bicycleSafetyFactor()).withPermission(seb.permission());
    }

    public Optional<StreetElevationExtension> build() {
        if (this.elevationProfileHasAtLeastTwoPoints() && (!this.isSlopeOverride || this.computed)) {
            return Optional.of(this.buildInternal());
        }
        return Optional.empty();
    }

    public StreetElevationExtensionBuilder withPermission(StreetTraversalPermission permission) {
        this.permission = permission;
        return this;
    }

    public StreetElevationExtensionBuilder withElevationProfile(PackedCoordinateSequence parentEdgeElevationProfile) {
        this.elevationProfile = parentEdgeElevationProfile;
        return this;
    }

    public StreetElevationExtensionBuilder withBicycleSafetyFactor(float bicycleSafetyFactor) {
        this.bicycleSafetyFactor = bicycleSafetyFactor;
        return this;
    }

    public StreetElevationExtensionBuilder withDistanceInMeters(double distanceInMeters) {
        this.distanceInMeters = distanceInMeters;
        return this;
    }

    public StreetElevationExtensionBuilder withWalkSafetyFactor(float walkSafetyFactor) {
        this.walkSafetyFactor = walkSafetyFactor;
        return this;
    }

    public StreetElevationExtensionBuilder withStairs(boolean stairs) {
        this.isStairs = stairs;
        return this;
    }

    public StreetElevationExtensionBuilder withComputed(boolean computed) {
        this.computed = computed;
        return this;
    }

    public StreetElevationExtensionBuilder withSlopeOverride(boolean slopeOverride) {
        this.isSlopeOverride = slopeOverride;
        return this;
    }

    private boolean elevationProfileHasAtLeastTwoPoints() {
        return this.elevationProfile != null && this.elevationProfile.size() >= 2;
    }

    private StreetElevationExtension buildInternal() {
        boolean slopeLimit = this.permission.allows(StreetTraversalPermission.CAR);
        SlopeCosts costs = ElevationUtils.getSlopeCosts((CoordinateSequence)this.elevationProfile, slopeLimit);
        double effectiveBikeDistanceFactor = costs.slopeSpeedFactor;
        double effectiveBikeWorkFactor = costs.slopeWorkFactor;
        double effectiveWalkDistanceFactor = costs.effectiveWalkFactor;
        float maxSlope = (float)costs.maxSlope;
        boolean flattened = costs.flattened;
        float effectiveBicycleSafetyFactor = (float)((double)this.bicycleSafetyFactor * costs.lengthMultiplier + costs.slopeSafetyCost / this.distanceInMeters);
        if (Double.isInfinite(effectiveBicycleSafetyFactor) || Double.isNaN(effectiveBicycleSafetyFactor)) {
            throw new IllegalStateException("Elevation updated bicycleSafetyFactor is " + effectiveBicycleSafetyFactor);
        }
        float effectiveWalkSafetyFactor = (float)((double)this.walkSafetyFactor * effectiveWalkDistanceFactor);
        if (Double.isInfinite(effectiveWalkSafetyFactor) || Double.isNaN(effectiveWalkSafetyFactor)) {
            throw new IllegalStateException("Elevation updated walkSafetyFactor is " + effectiveWalkSafetyFactor);
        }
        if (this.isStairs) {
            effectiveBikeDistanceFactor = 1.0;
            effectiveWalkDistanceFactor = 1.0;
        }
        return new StreetElevationExtension(this.distanceInMeters, this.computed, this.elevationProfile, effectiveBicycleSafetyFactor, effectiveBikeDistanceFactor, effectiveBikeWorkFactor, effectiveWalkDistanceFactor, effectiveWalkSafetyFactor, costs.lengthMultiplier, maxSlope, flattened);
    }
}

