/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.street.model.edge;

import java.io.Serializable;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.impl.PackedCoordinateSequence;
import org.opentripplanner.framework.geometry.CompactElevationProfile;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public class StreetElevationExtension
implements Serializable {
    private final double distanceMeters;
    private final byte[] compactedElevationProfile;
    private final PackedCoordinateSequence packedElevationProfile;
    private final double effectiveBicycleSafetyDistance;
    private final double effectiveBikeDistance;
    private final double effectiveBikeDistanceForWorkCost;
    private final double effectiveWalkDistance;
    private final double effectiveWalkSafetyDistance;
    private final double distanceWithElevation;
    private final float maxSlope;
    private final boolean flattened;

    StreetElevationExtension(double distanceMeters, boolean computed, PackedCoordinateSequence packedElevationProfile, float effectiveBicycleSafetyFactor, double effectiveBikeDistanceFactor, double effectiveBikeWorkFactor, double effectiveWalkDistanceFactor, double effectiveWalkSafetyFactor, double lengthMultiplier, float maxSlope, boolean flattened) {
        this.distanceMeters = distanceMeters;
        this.effectiveBicycleSafetyDistance = (double)effectiveBicycleSafetyFactor * distanceMeters;
        this.effectiveBikeDistance = effectiveBikeDistanceFactor * distanceMeters;
        this.effectiveBikeDistanceForWorkCost = effectiveBikeWorkFactor * distanceMeters;
        this.effectiveWalkDistance = effectiveWalkDistanceFactor * distanceMeters;
        this.effectiveWalkSafetyDistance = effectiveWalkSafetyFactor * distanceMeters;
        this.distanceWithElevation = lengthMultiplier * distanceMeters;
        this.maxSlope = maxSlope;
        this.flattened = flattened;
        if (computed) {
            this.compactedElevationProfile = null;
            this.packedElevationProfile = packedElevationProfile;
        } else {
            this.compactedElevationProfile = CompactElevationProfile.compactElevationProfileWithRegularSamples((CoordinateSequence)packedElevationProfile);
            this.packedElevationProfile = null;
        }
    }

    public PackedCoordinateSequence getElevationProfile() {
        if (this.compactedElevationProfile != null) {
            return CompactElevationProfile.uncompactElevationProfileWithRegularSamples(this.compactedElevationProfile, this.distanceMeters);
        }
        return this.packedElevationProfile;
    }

    public double getEffectiveBicycleSafetyDistance() {
        return this.effectiveBicycleSafetyDistance;
    }

    public double getEffectiveBikeDistance() {
        return this.effectiveBikeDistance;
    }

    public double getEffectiveBikeDistanceForWorkCost() {
        return this.effectiveBikeDistanceForWorkCost;
    }

    public double getEffectiveWalkDistance() {
        return this.effectiveWalkDistance;
    }

    public double getEffectiveWalkSafetyDistance() {
        return this.effectiveWalkSafetyDistance;
    }

    public double getDistanceWithElevation() {
        return this.distanceWithElevation;
    }

    public float getMaxSlope() {
        return this.maxSlope;
    }

    public boolean isFlattened() {
        return this.flattened;
    }

    public String toString() {
        return ToStringBuilder.of(StreetElevationExtension.class).addBoolIfTrue("flattened", Boolean.valueOf(this.flattened)).addNum("distanceMeters", (Number)this.distanceMeters).addNum("effectiveBicycleSafetyFactor", (Number)this.effectiveBicycleSafetyDistance).addNum("effectiveBikeDistance", (Number)this.effectiveBikeDistance).addNum("effectiveBikeDistanceForWorkCost", (Number)this.effectiveBikeDistanceForWorkCost).addNum("effectiveWalkDistance", (Number)this.effectiveWalkDistance).addNum("maxSlope", (Number)Float.valueOf(this.maxSlope)).toString();
    }
}

