/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.street.model.edge;

import org.locationtech.jts.geom.LineString;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.framework.i18n.NonLocalizedString;
import org.opentripplanner.street.model.StreetTraversalPermission;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.edge.StreetEdge;
import org.opentripplanner.street.model.edge.StreetElevationExtension;
import org.opentripplanner.street.model.vertex.StreetVertex;
import org.opentripplanner.street.search.TraverseMode;
import org.opentripplanner.utils.lang.BitSetUtils;

public class StreetEdgeBuilder<B extends StreetEdgeBuilder<B>> {
    public static final float DEFAULT_CAR_SPEED = 11.2f;
    public static final float DEFAULT_WALK_SAFETY_FACTOR = 1.0f;
    private static final float DEFAULT_BICYCLE_SAFETY_FACTOR = 1.0f;
    private StreetVertex from;
    private StreetVertex to;
    private LineString geometry;
    private I18NString name;
    private int millimeterLength;
    private StreetTraversalPermission permission;
    private boolean defaultLength;
    private float carSpeed;
    private float walkSafetyFactor;
    private float bicycleSafetyFactor;
    private short flags;
    private StreetElevationExtension streetElevationExtension;

    public StreetEdgeBuilder() {
        this.defaultLength = true;
        this.walkSafetyFactor = 1.0f;
        this.bicycleSafetyFactor = 1.0f;
        this.carSpeed = 11.2f;
        this.withWheelchairAccessible(true);
    }

    public StreetEdgeBuilder(StreetEdge original) {
        this.from = (StreetVertex)original.getFromVertex();
        this.to = (StreetVertex)original.getToVertex();
        this.geometry = original.getGeometry();
        this.name = original.getName();
        this.millimeterLength = original.getMillimeterLength();
        this.permission = original.getPermission();
        this.defaultLength = false;
        this.carSpeed = original.getCarSpeed();
        this.walkSafetyFactor = original.getWalkSafetyFactor();
        this.bicycleSafetyFactor = original.getBicycleSafetyFactor();
        this.flags = original.getFlags();
    }

    public StreetEdge buildAndConnect() {
        return Edge.connectToGraph(new StreetEdge(this));
    }

    public StreetVertex fromVertex() {
        return this.from;
    }

    public B withFromVertex(StreetVertex from) {
        this.from = from;
        return this.instance();
    }

    public StreetVertex toVertex() {
        return this.to;
    }

    public B withToVertex(StreetVertex to) {
        this.to = to;
        return this.instance();
    }

    public LineString geometry() {
        return this.geometry;
    }

    public B withGeometry(LineString geometry) {
        this.geometry = geometry;
        return this.instance();
    }

    public I18NString name() {
        return this.name;
    }

    public B withName(I18NString name) {
        this.name = name;
        return this.instance();
    }

    public B withName(String name) {
        this.name = new NonLocalizedString(name);
        return this.instance();
    }

    public int millimeterLength() {
        return this.millimeterLength;
    }

    public B withMeterLength(double length) {
        return this.withMilliMeterLength((int)(length * 1000.0));
    }

    public B withMilliMeterLength(int length) {
        this.millimeterLength = length;
        this.defaultLength = false;
        return this.instance();
    }

    public boolean hasDefaultLength() {
        return this.defaultLength;
    }

    public StreetTraversalPermission permission() {
        return this.permission;
    }

    public B withPermission(StreetTraversalPermission permission) {
        this.permission = permission;
        return this.instance();
    }

    public float carSpeed() {
        return this.carSpeed;
    }

    public B withCarSpeed(float carSpeed) {
        this.carSpeed = carSpeed;
        return this.instance();
    }

    public float walkSafetyFactor() {
        return this.walkSafetyFactor;
    }

    public B withWalkSafetyFactor(float walkSafetyFactor) {
        this.walkSafetyFactor = walkSafetyFactor;
        return this.instance();
    }

    public float bicycleSafetyFactor() {
        return this.bicycleSafetyFactor;
    }

    public B withBicycleSafetyFactor(float bicycleSafetyFactor) {
        this.bicycleSafetyFactor = bicycleSafetyFactor;
        return this.instance();
    }

    public short getFlags() {
        return this.flags;
    }

    public B withBack(boolean back) {
        this.flags = BitSetUtils.set((short)this.flags, (int)0, (boolean)back);
        return this.instance();
    }

    public B withLink(boolean link) {
        this.flags = BitSetUtils.set((short)this.flags, (int)9, (boolean)link);
        return this.instance();
    }

    public B withBogusName(boolean hasBogusName) {
        this.flags = BitSetUtils.set((short)this.flags, (int)2, (boolean)hasBogusName);
        return this.instance();
    }

    public B withStairs(boolean stairs) {
        this.flags = BitSetUtils.set((short)this.flags, (int)4, (boolean)stairs);
        return this.instance();
    }

    public B withWheelchairAccessible(boolean wheelchairAccessible) {
        this.flags = BitSetUtils.set((short)this.flags, (int)6, (boolean)wheelchairAccessible);
        return this.instance();
    }

    public B withSlopeOverride(boolean slopeOverride) {
        this.flags = BitSetUtils.set((short)this.flags, (int)5, (boolean)slopeOverride);
        return this.instance();
    }

    public B withRoundabout(boolean roundabout) {
        this.flags = BitSetUtils.set((short)this.flags, (int)1, (boolean)roundabout);
        return this.instance();
    }

    public B withMotorVehicleNoThruTraffic(boolean motorVehicleNoThruTraffic) {
        this.flags = BitSetUtils.set((short)this.flags, (int)3, (boolean)motorVehicleNoThruTraffic);
        return this.instance();
    }

    public B withBicycleNoThruTraffic(boolean bicycleNoThruTraffic) {
        this.flags = BitSetUtils.set((short)this.flags, (int)7, (boolean)bicycleNoThruTraffic);
        return this.instance();
    }

    public B withWalkNoThruTraffic(boolean walkNoThruTraffic) {
        this.flags = BitSetUtils.set((short)this.flags, (int)8, (boolean)walkNoThruTraffic);
        return this.instance();
    }

    public B withNoThruTrafficTraverseMode(TraverseMode noThruTrafficTraverseMode) {
        if (noThruTrafficTraverseMode == null) {
            return this.instance();
        }
        switch (noThruTrafficTraverseMode) {
            case WALK: {
                this.withWalkNoThruTraffic(true);
                break;
            }
            case BICYCLE: 
            case SCOOTER: {
                this.withBicycleNoThruTraffic(true);
                break;
            }
            case CAR: 
            case FLEX: {
                this.withMotorVehicleNoThruTraffic(true);
            }
        }
        return this.instance();
    }

    public boolean slopeOverride() {
        return BitSetUtils.get((short)this.flags, (int)5);
    }

    public boolean stairs() {
        return BitSetUtils.get((short)this.flags, (int)4);
    }

    public B withFlags(short flags) {
        this.flags = flags;
        return this.instance();
    }

    public B withElevationExtension(StreetElevationExtension streetElevationExtension) {
        this.streetElevationExtension = streetElevationExtension;
        return this.instance();
    }

    public StreetElevationExtension streetElevationExtension() {
        return this.streetElevationExtension;
    }

    final B instance() {
        return (B)this;
    }
}

