/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.street.model.edge;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.impl.PackedCoordinateSequence;
import org.opentripplanner.framework.geometry.CompactLineStringUtils;
import org.opentripplanner.framework.geometry.DirectionUtils;
import org.opentripplanner.framework.geometry.GeometryUtils;
import org.opentripplanner.framework.geometry.SphericalDistanceLibrary;
import org.opentripplanner.framework.geometry.SplitLineString;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.routing.api.request.preference.RoutingPreferences;
import org.opentripplanner.routing.api.request.preference.TimeSlopeSafetyTriangle;
import org.opentripplanner.routing.api.request.preference.VehicleRentalPreferences;
import org.opentripplanner.routing.core.VehicleRoutingOptimizeType;
import org.opentripplanner.routing.linking.DisposableEdgeCollection;
import org.opentripplanner.routing.util.ElevationUtils;
import org.opentripplanner.street.model.RentalRestrictionExtension;
import org.opentripplanner.street.model.StreetTraversalPermission;
import org.opentripplanner.street.model.edge.BikeWalkableEdge;
import org.opentripplanner.street.model.edge.CarPickupableEdge;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.edge.LinkingDirection;
import org.opentripplanner.street.model.edge.SplitStreetEdge;
import org.opentripplanner.street.model.edge.StreetEdgeBuilder;
import org.opentripplanner.street.model.edge.StreetEdgeCostExtension;
import org.opentripplanner.street.model.edge.StreetEdgeReluctanceCalculator;
import org.opentripplanner.street.model.edge.StreetElevationExtension;
import org.opentripplanner.street.model.edge.StreetElevationExtensionBuilder;
import org.opentripplanner.street.model.edge.TemporaryPartialStreetEdge;
import org.opentripplanner.street.model.edge.TemporaryPartialStreetEdgeBuilder;
import org.opentripplanner.street.model.edge.WheelchairTraversalInformation;
import org.opentripplanner.street.model.vertex.BarrierPassThroughVertex;
import org.opentripplanner.street.model.vertex.BarrierVertex;
import org.opentripplanner.street.model.vertex.IntersectionVertex;
import org.opentripplanner.street.model.vertex.SplitterVertex;
import org.opentripplanner.street.model.vertex.StreetVertex;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.street.search.TraverseMode;
import org.opentripplanner.street.search.TraverseModeSet;
import org.opentripplanner.street.search.state.State;
import org.opentripplanner.street.search.state.StateEditor;
import org.opentripplanner.street.search.state.VehicleRentalState;
import org.opentripplanner.utils.lang.BitSetUtils;
import org.opentripplanner.utils.lang.IntUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreetEdge
extends Edge
implements BikeWalkableEdge,
Cloneable,
CarPickupableEdge,
WheelchairTraversalInformation {
    private static final Logger LOG = LoggerFactory.getLogger(StreetEdge.class);
    private static final double SAFEST_STREETS_SAFETY_FACTOR = 0.1;
    static final int BACK_FLAG_INDEX = 0;
    static final int ROUNDABOUT_FLAG_INDEX = 1;
    static final int NAME_IS_DERIVED_FLAG_INDEX = 2;
    static final int MOTOR_VEHICLE_NOTHRUTRAFFIC = 3;
    static final int STAIRS_FLAG_INDEX = 4;
    static final int SLOPEOVERRIDE_FLAG_INDEX = 5;
    static final int WHEELCHAIR_ACCESSIBLE_FLAG_INDEX = 6;
    static final int BICYCLE_NOTHRUTRAFFIC = 7;
    static final int WALK_NOTHRUTRAFFIC = 8;
    static final int CLASS_LINK = 9;
    private StreetEdgeCostExtension costExtension;
    private short flags;
    private final int length_mm;
    private float bicycleSafetyFactor;
    private float walkSafetyFactor;
    private byte[] compactGeometry;
    private I18NString name;
    private StreetTraversalPermission permission;
    private final float carSpeed;
    private final byte inAngle;
    private final byte outAngle;
    private StreetElevationExtension elevationExtension;

    protected StreetEdge(StreetEdgeBuilder<?> builder) {
        super(builder.fromVertex(), builder.toVertex());
        this.flags = builder.getFlags();
        this.setGeometry(builder.geometry());
        this.length_mm = this.computeLength(builder);
        this.setBicycleSafetyFactor(builder.bicycleSafetyFactor());
        this.setWalkSafetyFactor(builder.walkSafetyFactor());
        this.name = builder.name();
        this.setPermission(builder.permission());
        this.carSpeed = builder.carSpeed();
        LineStringInOutAngles lineStringInOutAngles = LineStringInOutAngles.of(builder.geometry());
        this.inAngle = lineStringInOutAngles.inAngle();
        this.outAngle = lineStringInOutAngles.outAngle();
        this.elevationExtension = builder.streetElevationExtension();
    }

    public StreetEdgeBuilder<?> toBuilder() {
        return new StreetEdgeBuilder(this);
    }

    public boolean canTraverse(TraverseModeSet modes) {
        return this.getPermission().allows(modes);
    }

    public boolean canTraverse(TraverseMode mode) {
        StreetTraversalPermission permission = this.getPermission();
        if (this.fromv instanceof BarrierVertex) {
            permission = permission.intersection(((BarrierVertex)this.fromv).getBarrierPermissions());
        }
        if (this.tov instanceof BarrierVertex) {
            permission = permission.intersection(((BarrierVertex)this.tov).getBarrierPermissions());
        }
        return permission.allows(mode);
    }

    public void setElevationExtension(StreetElevationExtension streetElevationExtension) {
        this.elevationExtension = streetElevationExtension;
    }

    public boolean hasElevationExtension() {
        return this.elevationExtension != null;
    }

    public PackedCoordinateSequence getElevationProfile() {
        return this.hasElevationExtension() ? this.elevationExtension.getElevationProfile() : null;
    }

    public boolean isElevationFlattened() {
        return this.hasElevationExtension() && this.elevationExtension.isFlattened();
    }

    public double getMaxSlope() {
        return this.hasElevationExtension() ? (double)this.elevationExtension.getMaxSlope() : 0.0;
    }

    public boolean isNoThruTraffic(TraverseMode traverseMode) {
        return switch (traverseMode) {
            default -> throw new MatchException(null, null);
            case TraverseMode.WALK -> this.isWalkNoThruTraffic();
            case TraverseMode.BICYCLE, TraverseMode.SCOOTER -> this.isBicycleNoThruTraffic();
            case TraverseMode.CAR, TraverseMode.FLEX -> this.isMotorVehicleNoThruTraffic();
        };
    }

    public double calculateSpeed(RoutingPreferences preferences, TraverseMode traverseMode, boolean walkingBike) {
        if (traverseMode == null) {
            return Double.NaN;
        }
        double speed = switch (traverseMode) {
            default -> throw new MatchException(null, null);
            case TraverseMode.WALK -> {
                if (walkingBike) {
                    yield preferences.bike().walking().speed();
                }
                yield preferences.walk().speed();
            }
            case TraverseMode.BICYCLE -> Math.min(preferences.bike().speed(), this.getCyclingSpeedLimit());
            case TraverseMode.CAR -> this.getCarSpeed();
            case TraverseMode.SCOOTER -> Math.min(preferences.scooter().speed(), this.getCyclingSpeedLimit());
            case TraverseMode.FLEX -> throw new IllegalArgumentException("getSpeed(): Invalid mode " + String.valueOf((Object)traverseMode));
        };
        return this.isStairs() ? speed / preferences.walk().stairsTimeFactor() : speed;
    }

    public double getEffectiveBikeDistance() {
        return this.hasElevationExtension() ? this.elevationExtension.getEffectiveBikeDistance() : this.getDistanceMeters();
    }

    public double getEffectiveBikeDistanceForWorkCost() {
        return this.hasElevationExtension() ? this.elevationExtension.getEffectiveBikeDistanceForWorkCost() : this.getDistanceMeters();
    }

    public float getBicycleSafetyFactor() {
        return this.bicycleSafetyFactor;
    }

    public void setBicycleSafetyFactor(float bicycleSafetyFactor) {
        if (this.hasElevationExtension()) {
            throw new IllegalStateException("A bicycle safety factor may not be set if an elevation extension is set.");
        }
        if (!Float.isFinite(bicycleSafetyFactor) || bicycleSafetyFactor <= 0.0f) {
            throw new IllegalArgumentException("Invalid bicycleSafetyFactor: " + bicycleSafetyFactor);
        }
        this.bicycleSafetyFactor = bicycleSafetyFactor;
    }

    public double getEffectiveBicycleSafetyDistance() {
        return this.elevationExtension != null ? this.elevationExtension.getEffectiveBicycleSafetyDistance() : (double)this.bicycleSafetyFactor * this.getDistanceMeters();
    }

    public float getWalkSafetyFactor() {
        return this.walkSafetyFactor;
    }

    public void setWalkSafetyFactor(float walkSafetyFactor) {
        if (this.hasElevationExtension()) {
            throw new IllegalStateException("A walk safety factor may not be set if an elevation extension is set.");
        }
        if (!Float.isFinite(walkSafetyFactor) || walkSafetyFactor <= 0.0f) {
            throw new IllegalArgumentException("Invalid walkSafetyFactor: " + walkSafetyFactor);
        }
        this.walkSafetyFactor = walkSafetyFactor;
    }

    public double getEffectiveWalkSafetyDistance() {
        return this.elevationExtension != null ? this.elevationExtension.getEffectiveWalkSafetyDistance() : (double)this.walkSafetyFactor * this.getDistanceMeters();
    }

    @Override
    public String toString() {
        String nameString = this.name != null ? this.name.toString() : null;
        return this.buildToString(nameString, b -> b.append(", length=").append(this.getDistanceMeters()).append(", carSpeed=").append(this.getCarSpeed()).append(", permission=").append((Object)this.getPermission()));
    }

    @Override
    public boolean isRoundabout() {
        return BitSetUtils.get((short)this.flags, (int)1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public State[] traverse(State s0) {
        StateEditor dropOff;
        StateEditor inCar;
        StateEditor afterTraversal;
        State state;
        StateEditor editor;
        boolean arriveByRental;
        boolean bl = arriveByRental = s0.getRequest().mode().includesRenting() && s0.getRequest().arriveBy();
        if (arriveByRental && this.tov.rentalTraversalBanned(s0)) {
            return State.empty();
        }
        if (arriveByRental && this.hasStartedWalkingInNoDropOffZoneAndIsExitingIt(s0)) {
            return this.splitStatesAfterHavingExitedNoDropOffZoneWhenReverseSearching(s0);
        }
        if (s0.getRequest().mode().includesRenting() && this.tov.rentalTraversalBanned(s0)) {
            editor = this.doTraverse(s0, TraverseMode.WALK, false);
            if (editor != null) {
                editor.dropFloatingVehicle(s0.vehicleRentalFormFactor(), s0.getVehicleRentalNetwork(), s0.getRequest().arriveBy());
            }
        } else if (arriveByRental && this.leavesZoneWithRentalRestrictionsWhenHavingRented(s0)) {
            editor = this.doTraverse(s0, TraverseMode.WALK, false);
            if (editor != null) {
                editor.dropFloatingVehicle(s0.vehicleRentalFormFactor(), s0.getVehicleRentalNetwork(), s0.getRequest().arriveBy());
            }
        } else if (s0.currentMode() == TraverseMode.BICYCLE) {
            if (this.canTraverse(TraverseMode.BICYCLE)) {
                editor = this.doTraverse(s0, TraverseMode.BICYCLE, false);
            } else {
                if (!this.canTraverse(TraverseMode.WALK)) return State.empty();
                editor = this.doTraverse(s0, TraverseMode.WALK, true);
            }
        } else {
            editor = this.canTraverse(s0.currentMode()) ? this.doTraverse(s0, s0.currentMode(), false) : null;
        }
        State state2 = state = editor != null ? editor.makeState() : null;
        if (state != null && !this.fromv.rentalDropOffBanned(s0) && this.tov.rentalDropOffBanned(s0) && (afterTraversal = this.doTraverse(s0, TraverseMode.WALK, false)) != null) {
            afterTraversal.dropFloatingVehicle(state.vehicleRentalFormFactor(), state.getVehicleRentalNetwork(), state.getRequest().arriveBy());
            afterTraversal.leaveNoRentalDropOffArea();
            State forkState = afterTraversal.makeState();
            return State.ofNullable(forkState, state);
        }
        if (state != null && arriveByRental && this.leavesZoneWithRentalRestrictionsWhenHavingRented(s0)) {
            StateEditor walking = this.doTraverse(s0, TraverseMode.WALK, false);
            State forkState = walking.makeState();
            return State.ofNullable(forkState, state);
        }
        if (this.canPickupAndDrive(s0) && this.canTraverse(TraverseMode.CAR) && (inCar = this.doTraverse(s0, TraverseMode.CAR, false)) != null) {
            this.driveAfterPickup(s0, inCar);
            State forkState = inCar.makeState();
            return State.ofNullable(forkState, state);
        }
        if (!this.canDropOffAfterDriving(s0) || this.getPermission().allows(TraverseMode.CAR) || !this.canTraverse(TraverseMode.WALK) || (dropOff = this.doTraverse(s0, TraverseMode.WALK, false)) == null) return State.ofNullable(state);
        this.dropOffAfterDriving(s0, dropOff);
        return dropOff.makeStateArray();
    }

    @Override
    public I18NString getName() {
        return this.name;
    }

    public void setName(I18NString name) {
        this.name = name;
        this.flags = BitSetUtils.set((short)this.flags, (int)2, (boolean)false);
    }

    @Override
    public boolean nameIsDerived() {
        return BitSetUtils.get((short)this.flags, (int)2);
    }

    @Override
    public LineString getGeometry() {
        return CompactLineStringUtils.uncompactLineString(this.fromv.getLon(), this.fromv.getLat(), this.tov.getLon(), this.tov.getLat(), this.compactGeometry, this.isBack());
    }

    @Override
    public double getDistanceMeters() {
        return (double)this.length_mm / 1000.0;
    }

    @Override
    public double getEffectiveWalkDistance() {
        return this.hasElevationExtension() ? this.elevationExtension.getEffectiveWalkDistance() : this.getDistanceMeters();
    }

    public void removeRentalExtension(RentalRestrictionExtension ext) {
        this.fromv.removeRentalRestriction(ext);
        this.tov.removeRentalRestriction(ext);
    }

    public StreetEdge clone() {
        try {
            return (StreetEdge)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public void shareData(StreetEdge reversedEdge) {
        if (Arrays.equals(this.compactGeometry, reversedEdge.compactGeometry)) {
            this.compactGeometry = reversedEdge.compactGeometry;
        } else {
            LOG.warn("Can't share geometry between {} and {}", (Object)this, (Object)reversedEdge);
        }
    }

    @Override
    public boolean isWheelchairAccessible() {
        return BitSetUtils.get((short)this.flags, (int)6);
    }

    public StreetTraversalPermission getPermission() {
        return this.permission;
    }

    public void setPermission(StreetTraversalPermission permission) {
        this.permission = Objects.requireNonNull(permission);
    }

    public boolean isBack() {
        return BitSetUtils.get((short)this.flags, (int)0);
    }

    public boolean isWalkNoThruTraffic() {
        return BitSetUtils.get((short)this.flags, (int)8);
    }

    public void setWalkNoThruTraffic(boolean noThruTraffic) {
        this.flags = BitSetUtils.set((short)this.flags, (int)8, (boolean)noThruTraffic);
    }

    public boolean isMotorVehicleNoThruTraffic() {
        return BitSetUtils.get((short)this.flags, (int)3);
    }

    public void setMotorVehicleNoThruTraffic(boolean noThruTraffic) {
        this.flags = BitSetUtils.set((short)this.flags, (int)3, (boolean)noThruTraffic);
    }

    public boolean isBicycleNoThruTraffic() {
        return BitSetUtils.get((short)this.flags, (int)7);
    }

    public void setBicycleNoThruTraffic(boolean noThruTraffic) {
        this.flags = BitSetUtils.set((short)this.flags, (int)7, (boolean)noThruTraffic);
    }

    public boolean isStairs() {
        return BitSetUtils.get((short)this.flags, (int)4);
    }

    public boolean isLink() {
        return BitSetUtils.get((short)this.flags, (int)9);
    }

    public float getCarSpeed() {
        return this.carSpeed;
    }

    private double getCyclingSpeedLimit() {
        return this.hasElevationExtension() ? (double)this.getCarSpeed() * (this.elevationExtension.getEffectiveBikeDistance() / this.getDistanceMeters()) : (double)this.getCarSpeed();
    }

    public boolean isSlopeOverride() {
        return BitSetUtils.get((short)this.flags, (int)5);
    }

    public int getInAngle() {
        return IntUtils.round((double)((double)(this.inAngle * 180) / 128.0));
    }

    public int getOutAngle() {
        return IntUtils.round((double)((double)(this.outAngle * 180) / 128.0));
    }

    public void setCostExtension(StreetEdgeCostExtension costExtension) {
        this.costExtension = costExtension;
    }

    public void addRentalRestriction(RentalRestrictionExtension ext) {
        this.fromv.addRentalRestriction(ext);
    }

    public SplitStreetEdge splitDestructively(SplitterVertex v) {
        SplitLineString geoms = GeometryUtils.splitGeometryAtPoint((Geometry)this.getGeometry(), v.getCoordinate());
        Object seb1 = ((StreetEdgeBuilder)((StreetEdgeBuilder)((StreetEdgeBuilder)((StreetEdgeBuilder)((StreetEdgeBuilder)new StreetEdgeBuilder().withFromVertex((StreetVertex)this.fromv)).withToVertex(v)).withGeometry(geoms.beginning())).withName(this.name)).withPermission(this.permission)).withBack(this.isBack());
        Object seb2 = ((StreetEdgeBuilder)((StreetEdgeBuilder)((StreetEdgeBuilder)((StreetEdgeBuilder)((StreetEdgeBuilder)new StreetEdgeBuilder().withFromVertex(v)).withToVertex((StreetVertex)this.tov)).withGeometry(geoms.ending())).withName(this.name)).withPermission(this.permission)).withBack(this.isBack());
        int l1 = StreetEdge.defaultMillimeterLength(geoms.beginning());
        int l2 = StreetEdge.defaultMillimeterLength(geoms.ending());
        if (!this.isBack()) {
            frac = (double)l1 / (double)(l1 + l2);
            l1 = (int)((double)this.length_mm * frac);
            l2 = this.length_mm - l1;
        } else {
            frac = (double)l2 / (double)(l1 + l2);
            l2 = (int)((double)this.length_mm * frac);
            l1 = this.length_mm - l2;
        }
        if (l1 <= 0) {
            LOG.error("Edge 1 ({}) split at vertex at {},{} has length {} mm. Setting to 1 mm.", new Object[]{this.name, v.getLat(), v.getLon(), l1});
            l1 = 1;
        }
        if (l2 <= 0) {
            LOG.error("Edge 2 ({}) split at vertex at {},{}  has length {} mm. Setting to 1 mm.", new Object[]{this.name, v.getLat(), v.getLon(), l2});
            l2 = 1;
        }
        ((StreetEdgeBuilder)seb1).withMilliMeterLength(l1);
        ((StreetEdgeBuilder)seb2).withMilliMeterLength(l2);
        this.copyPropertiesToSplitEdge((StreetEdgeBuilder<?>)seb1, 0.0, (double)l1 / 1000.0);
        this.copyPropertiesToSplitEdge((StreetEdgeBuilder<?>)seb2, (double)l1 / 1000.0, this.getDistanceMeters());
        StreetEdge se1 = ((StreetEdgeBuilder)seb1).buildAndConnect();
        StreetEdge se2 = ((StreetEdgeBuilder)seb2).buildAndConnect();
        this.copyRentalRestrictionsToSplitEdge(se1);
        this.copyRentalRestrictionsToSplitEdge(se2);
        return new SplitStreetEdge(se1, se2);
    }

    public SplitStreetEdge splitNonDestructively(SplitterVertex v, DisposableEdgeCollection tempEdges, LinkingDirection direction) {
        SplitLineString geoms = GeometryUtils.splitGeometryAtPoint((Geometry)this.getGeometry(), v.getCoordinate());
        TemporaryPartialStreetEdge e1 = null;
        TemporaryPartialStreetEdge e2 = null;
        if (direction == LinkingDirection.OUTGOING || direction == LinkingDirection.BIDIRECTIONAL) {
            TemporaryPartialStreetEdgeBuilder seb1 = (TemporaryPartialStreetEdgeBuilder)((TemporaryPartialStreetEdgeBuilder)((TemporaryPartialStreetEdgeBuilder)((TemporaryPartialStreetEdgeBuilder)((TemporaryPartialStreetEdgeBuilder)new TemporaryPartialStreetEdgeBuilder().withParentEdge(this).withFromVertex((StreetVertex)this.fromv)).withToVertex(v)).withGeometry(geoms.beginning())).withName(this.name)).withBack(this.isBack());
            this.copyPropertiesToSplitEdge(seb1, 0.0, (double)StreetEdge.defaultMillimeterLength(geoms.beginning()) / 1000.0);
            e1 = seb1.buildAndConnect();
            this.copyRentalRestrictionsToSplitEdge(e1);
            tempEdges.addEdge(e1);
        }
        if (direction == LinkingDirection.INCOMING || direction == LinkingDirection.BIDIRECTIONAL) {
            TemporaryPartialStreetEdgeBuilder seb2 = (TemporaryPartialStreetEdgeBuilder)((TemporaryPartialStreetEdgeBuilder)((TemporaryPartialStreetEdgeBuilder)((TemporaryPartialStreetEdgeBuilder)((TemporaryPartialStreetEdgeBuilder)new TemporaryPartialStreetEdgeBuilder().withParentEdge(this).withFromVertex(v)).withToVertex((StreetVertex)this.tov)).withGeometry(geoms.ending())).withName(this.name)).withBack(this.isBack());
            this.copyPropertiesToSplitEdge(seb2, this.getDistanceMeters() - (double)StreetEdge.defaultMillimeterLength(geoms.ending()) / 1000.0, this.getDistanceMeters());
            e2 = seb2.buildAndConnect();
            this.copyRentalRestrictionsToSplitEdge(e2);
            tempEdges.addEdge(e2);
        }
        return new SplitStreetEdge(e1, e2);
    }

    public Optional<Edge> createPartialEdge(StreetVertex from, StreetVertex to) {
        LineString parent = this.getGeometry();
        LineString head = GeometryUtils.getInteriorSegment((Geometry)parent, this.getFromVertex().getCoordinate(), from.getCoordinate());
        LineString tail = GeometryUtils.getInteriorSegment((Geometry)parent, to.getCoordinate(), this.getToVertex().getCoordinate());
        if (parent.getLength() > head.getLength() + tail.getLength()) {
            LineString partial = GeometryUtils.getInteriorSegment((Geometry)parent, from.getCoordinate(), to.getCoordinate());
            double startRatio = head.getLength() / parent.getLength();
            double start = this.getDistanceMeters() * startRatio;
            double lengthRatio = partial.getLength() / parent.getLength();
            double length = this.getDistanceMeters() * lengthRatio;
            TemporaryPartialStreetEdgeBuilder tpseb = (TemporaryPartialStreetEdgeBuilder)((TemporaryPartialStreetEdgeBuilder)((TemporaryPartialStreetEdgeBuilder)((TemporaryPartialStreetEdgeBuilder)((TemporaryPartialStreetEdgeBuilder)new TemporaryPartialStreetEdgeBuilder().withParentEdge(this).withFromVertex(from)).withToVertex(to)).withGeometry(partial)).withName(this.getName())).withMeterLength(length);
            this.copyPropertiesToSplitEdge(tpseb, start, start + length);
            TemporaryPartialStreetEdge se = tpseb.buildAndConnect();
            this.copyRentalRestrictionsToSplitEdge(se);
            return Optional.of(se);
        }
        return Optional.empty();
    }

    protected void copyPropertiesToSplitEdge(StreetEdgeBuilder<?> seb, double fromDistance, double toDistance) {
        seb.withFlags(this.flags);
        seb.withBicycleSafetyFactor(this.bicycleSafetyFactor);
        seb.withWalkSafetyFactor(this.walkSafetyFactor);
        seb.withCarSpeed(this.carSpeed);
        PackedCoordinateSequence partialElevationProfileFromParent = ElevationUtils.getPartialElevationProfile(this.getElevationProfile(), fromDistance, toDistance);
        StreetElevationExtensionBuilder.of(seb).withDistanceInMeters((double)StreetEdge.defaultMillimeterLength(seb.geometry()) / 1000.0).withElevationProfile(partialElevationProfileFromParent).build().ifPresent(seb::withElevationExtension);
    }

    protected void copyRentalRestrictionsToSplitEdge(StreetEdge splitEdge) {
        splitEdge.addRentalRestriction(this.fromv.rentalRestrictions());
    }

    short getFlags() {
        return this.flags;
    }

    int getMillimeterLength() {
        return this.length_mm;
    }

    private int computeLength(StreetEdgeBuilder<?> builder) {
        int lengthInMillimeter;
        int n = lengthInMillimeter = builder.hasDefaultLength() ? StreetEdge.defaultMillimeterLength(builder.geometry()) : builder.millimeterLength();
        if (lengthInMillimeter == 0 && !(this.getFromVertex() instanceof BarrierPassThroughVertex) && !(this.getToVertex() instanceof BarrierPassThroughVertex)) {
            LOG.warn("StreetEdge {} from {} to {} has length of 0. This is usually an error.", new Object[]{this.name, builder.fromVertex(), builder.toVertex()});
        }
        return lengthInMillimeter;
    }

    static int defaultMillimeterLength(LineString geometry) {
        return (int)(SphericalDistanceLibrary.length(geometry) * 1000.0);
    }

    private State createStateAfterHavingExitedNoDropOffZoneWhenReverseSearching(State s0, String network, RoutingPreferences preferences) {
        StateEditor edit = this.doTraverse(s0, TraverseMode.WALK, false);
        if (edit != null) {
            State state;
            edit.dropFloatingVehicle(s0.vehicleRentalFormFactor(), network, s0.getRequest().arriveBy());
            if (network != null) {
                edit.resetStartedInNoDropOffZone();
            }
            if ((state = edit.makeState()) != null && network != null) {
                VehicleRentalPreferences rentalPreferences = preferences.rental(state.currentMode());
                Set<String> allowedNetworks = rentalPreferences.allowedNetworks();
                Set<String> bannedNetworks = rentalPreferences.bannedNetworks();
                if (allowedNetworks.isEmpty() ? bannedNetworks.contains(network) : !allowedNetworks.contains(network)) {
                    return null;
                }
            }
            return state;
        }
        return null;
    }

    private State[] splitStatesAfterHavingExitedNoDropOffZoneWhenReverseSearching(State s0) {
        RoutingPreferences preferences = s0.getRequest().preferences();
        ArrayList<State> states = new ArrayList<State>();
        StateEditor walking = this.doTraverse(s0, TraverseMode.WALK, false);
        if (walking != null) {
            states.add(walking.makeState());
        }
        boolean hasNetworkStates = false;
        for (String network : this.tov.rentalRestrictions().noDropOffNetworks()) {
            State state = this.createStateAfterHavingExitedNoDropOffZoneWhenReverseSearching(s0, network, preferences);
            if (state == null) continue;
            states.add(state);
            hasNetworkStates = true;
        }
        if (hasNetworkStates) {
            states.add(this.createStateAfterHavingExitedNoDropOffZoneWhenReverseSearching(s0, null, preferences));
        }
        return (State[])states.toArray(State[]::new);
    }

    private boolean leavesZoneWithRentalRestrictionsWhenHavingRented(State s0) {
        return s0.getVehicleRentalState() == VehicleRentalState.HAVE_RENTED && !this.fromv.rentalRestrictions().hasRestrictions() && this.tov.rentalRestrictions().hasRestrictions();
    }

    private boolean hasStartedWalkingInNoDropOffZoneAndIsExitingIt(State s0) {
        return s0.currentMode() == TraverseMode.WALK && !s0.stateData.noRentalDropOffZonesAtStartOfReverseSearch.isEmpty() && this.fromv.rentalRestrictions().noDropOffNetworks().isEmpty() && !this.tov.rentalRestrictions().noDropOffNetworks().isEmpty();
    }

    private void setGeometry(LineString geometry) {
        this.compactGeometry = CompactLineStringUtils.compactLineString(this.fromv.getLon(), this.fromv.getLat(), this.tov.getLon(), this.tov.getLat(), this.isBack() ? geometry.reverse() : geometry, this.isBack());
    }

    private double getDistanceWithElevation() {
        return this.hasElevationExtension() ? this.elevationExtension.getDistanceWithElevation() : this.getDistanceMeters();
    }

    private StateEditor doTraverse(State s0, TraverseMode traverseMode, boolean walkingBike) {
        Edge backEdge = s0.getBackEdge();
        if (backEdge != null && this.isReverseOf(backEdge)) {
            return null;
        }
        StateEditor s1 = this.createEditor(s0, this, traverseMode, walkingBike);
        if (this.isTraversalBlockedByNoThruTraffic(traverseMode, backEdge, s0, s1)) {
            return null;
        }
        if (s0.getRequest().mode().includesRenting()) {
            if (this.tov.rentalDropOffBanned(s0)) {
                s1.enterNoRentalDropOffArea();
            } else if (s0.isInsideNoRentalDropOffArea() && !this.tov.rentalDropOffBanned(s0)) {
                s1.leaveNoRentalDropOffArea();
            }
        }
        RoutingPreferences preferences = s0.getPreferences();
        double speed = this.calculateSpeed(preferences, traverseMode, walkingBike);
        TraversalCosts traversalCosts = switch (traverseMode) {
            case TraverseMode.BICYCLE, TraverseMode.SCOOTER -> this.bicycleOrScooterTraversalCost(preferences, traverseMode, speed);
            case TraverseMode.WALK -> this.walkingTraversalCosts(preferences, traverseMode, speed, walkingBike, s0.getRequest().wheelchair());
            default -> this.otherTraversalCosts(preferences, traverseMode, walkingBike, speed);
        };
        long time_ms = (long)Math.ceil(1000.0 * traversalCosts.time());
        double weight = traversalCosts.weight();
        if (backEdge instanceof StreetEdge) {
            double turnDuration;
            Vertex vertex;
            StreetEdge backPSE = (StreetEdge)backEdge;
            TraverseMode backMode = s0.getBackMode();
            boolean arriveBy = s0.getRequest().arriveBy();
            double backSpeed = backPSE.calculateSpeed(preferences, backMode, s0.isBackWalkingBike());
            if (arriveBy && (vertex = this.tov) instanceof IntersectionVertex) {
                IntersectionVertex traversedVertex = (IntersectionVertex)vertex;
                turnDuration = s0.intersectionTraversalCalculator().computeTraversalDuration(traversedVertex, this, backPSE, backMode, (float)speed, (float)backSpeed);
            } else if (!arriveBy && (vertex = this.fromv) instanceof IntersectionVertex) {
                IntersectionVertex traversedVertex = (IntersectionVertex)vertex;
                turnDuration = s0.intersectionTraversalCalculator().computeTraversalDuration(traversedVertex, backPSE, this, traverseMode, (float)backSpeed, (float)speed);
            } else {
                LOG.debug("Not computing turn duration for edge {}", (Object)this);
                turnDuration = 0.0;
            }
            time_ms += (long)Math.ceil(1000.0 * turnDuration);
            weight += preferences.street().turnReluctance() * turnDuration;
        }
        if (!traverseMode.isInCar()) {
            s1.incrementWalkDistance(this.getDistanceWithElevation());
        }
        if (this.costExtension != null) {
            weight += this.costExtension.calculateExtraCost(s0, this.length_mm, traverseMode);
        }
        s1.incrementTimeInMilliseconds(time_ms);
        s1.incrementWeight(weight);
        return s1;
    }

    private TraversalCosts otherTraversalCosts(RoutingPreferences preferences, TraverseMode traverseMode, boolean walkingBike, double speed) {
        double time = this.getDistanceMeters() / speed;
        double weight = time * StreetEdgeReluctanceCalculator.computeReluctance(preferences, traverseMode, walkingBike, this.isStairs());
        return new TraversalCosts(time, weight);
    }

    private TraversalCosts bicycleOrScooterTraversalCost(RoutingPreferences pref, TraverseMode mode, double speed) {
        double time = this.getEffectiveBikeDistance() / speed;
        VehicleRoutingOptimizeType optimizeType = mode == TraverseMode.BICYCLE ? pref.bike().optimizeType() : pref.scooter().optimizeType();
        switch (optimizeType) {
            case SAFEST_STREETS: {
                double weight = (double)this.bicycleSafetyFactor * this.getDistanceMeters() / speed;
                if (!((double)this.bicycleSafetyFactor <= 0.1)) break;
                weight *= 0.66;
                break;
            }
            case SAFE_STREETS: {
                double weight = this.getEffectiveBicycleSafetyDistance() / speed;
                break;
            }
            case FLAT_STREETS: {
                double weight = this.getEffectiveBikeDistanceForWorkCost() / speed;
                break;
            }
            case SHORTEST_DURATION: {
                double weight = this.getEffectiveBikeDistance() / speed;
                break;
            }
            case TRIANGLE: {
                double quick = this.getEffectiveBikeDistance();
                double safety = this.getEffectiveBicycleSafetyDistance();
                double slope = this.getEffectiveBikeDistanceForWorkCost();
                TimeSlopeSafetyTriangle triangle = mode == TraverseMode.BICYCLE ? pref.bike().optimizeTriangle() : pref.scooter().optimizeTriangle();
                double weight = quick * triangle.time() + slope * triangle.slope() + safety * triangle.safety();
                weight /= speed;
                break;
            }
            default: {
                double weight = this.getDistanceMeters() / speed;
            }
        }
        double reluctance = StreetEdgeReluctanceCalculator.computeReluctance(pref, mode, false, this.isStairs());
        return new TraversalCosts(time, weight *= reluctance);
    }

    private TraversalCosts walkingTraversalCosts(RoutingPreferences preferences, TraverseMode traverseMode, double speed, boolean walkingBike, boolean wheelchair) {
        double weight;
        double time;
        if (wheelchair) {
            time = this.getEffectiveWalkDistance() / speed;
            weight = this.getEffectiveBikeDistance() / speed * StreetEdgeReluctanceCalculator.computeWheelchairReluctance(preferences, this.getMaxSlope(), this.isWheelchairAccessible(), this.isStairs());
        } else {
            if (walkingBike) {
                time = weight = this.getEffectiveBikeDistance() / speed;
                if (this.isStairs()) {
                    weight *= preferences.bike().walking().stairsReluctance();
                }
            } else {
                time = this.getEffectiveWalkDistance() / speed;
                weight = this.getEffectiveWalkSafetyDistance() * preferences.walk().safetyFactor() + this.getEffectiveWalkDistance() * (1.0 - preferences.walk().safetyFactor());
                weight /= speed;
            }
            weight *= StreetEdgeReluctanceCalculator.computeReluctance(preferences, traverseMode, walkingBike, this.isStairs());
        }
        return new TraversalCosts(time, weight);
    }

    private boolean isTraversalBlockedByNoThruTraffic(TraverseMode traverseMode, Edge backEdge, State s0, StateEditor s1) {
        if (this.isNoThruTraffic(traverseMode)) {
            StreetEdge sbe;
            if (backEdge instanceof StreetEdge && !(sbe = (StreetEdge)backEdge).isNoThruTraffic(traverseMode)) {
                s1.setEnteredNoThroughTrafficArea();
            }
        } else if (s0.hasEnteredNoThruTrafficArea()) {
            return true;
        }
        return false;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private record LineStringInOutAngles(byte inAngle, byte outAngle) {
        private static final LineStringInOutAngles DEFAULT = new LineStringInOutAngles(0, 0);

        public static LineStringInOutAngles of(LineString geometry) {
            if (geometry == null) {
                return DEFAULT;
            }
            try {
                byte in = LineStringInOutAngles.convertRadianToByte(DirectionUtils.getFirstAngle((Geometry)geometry));
                byte out = LineStringInOutAngles.convertRadianToByte(DirectionUtils.getLastAngle((Geometry)geometry));
                return new LineStringInOutAngles(in, out);
            }
            catch (Exception e) {
                LOG.info("Exception while determining LineString angles. setting to zero. There is probably something wrong with this segment's geometry.");
                return DEFAULT;
            }
        }

        private static byte convertRadianToByte(double angleRadians) {
            return (byte)Math.round(angleRadians * 128.0 / Math.PI);
        }
    }

    private record TraversalCosts(double time, double weight) {
    }
}

