/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.street.model.edge;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.framework.geometry.GeometryUtils;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.framework.i18n.NonLocalizedString;
import org.opentripplanner.routing.api.request.preference.RoutingPreferences;
import org.opentripplanner.street.model.edge.BikeWalkableEdge;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.edge.StreetEdgeReluctanceCalculator;
import org.opentripplanner.street.model.edge.WheelchairTraversalInformation;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.street.search.TraverseMode;
import org.opentripplanner.street.search.state.State;
import org.opentripplanner.street.search.state.StateEditor;
import org.opentripplanner.transit.model.site.PathwayMode;

public class PathwayEdge
extends Edge
implements BikeWalkableEdge,
WheelchairTraversalInformation {
    public static final I18NString DEFAULT_NAME = new NonLocalizedString("pathway");
    @Nullable
    private final I18NString signpostedAs;
    private final int traversalTime;
    private final double distance;
    private final int steps;
    private final double slope;
    private final PathwayMode mode;
    private final boolean wheelchairAccessible;

    private PathwayEdge(Vertex fromv, Vertex tov, @Nullable I18NString signpostedAs, int traversalTime, double distance, int steps, double slope, boolean wheelchairAccessible, PathwayMode mode) {
        super(fromv, tov);
        this.signpostedAs = signpostedAs;
        this.traversalTime = traversalTime;
        this.steps = steps;
        this.slope = slope;
        this.wheelchairAccessible = wheelchairAccessible;
        this.distance = distance;
        this.mode = mode;
    }

    public static PathwayEdge createLowCostPathwayEdge(Vertex fromV, Vertex toV, PathwayMode mode) {
        return PathwayEdge.createLowCostPathwayEdge(fromV, toV, true, mode);
    }

    public static PathwayEdge createLowCostPathwayEdge(Vertex fromV, Vertex toV, boolean wheelchairAccessible, PathwayMode mode) {
        return PathwayEdge.createPathwayEdge(fromV, toV, null, 0, 0.0, 0, 0.0, wheelchairAccessible, mode);
    }

    public static PathwayEdge createPathwayEdge(Vertex fromv, Vertex tov, I18NString signpostedAs, int traversalTime, double distance, int steps, double slope, boolean wheelchairAccessible, PathwayMode mode) {
        return PathwayEdge.connectToGraph(new PathwayEdge(fromv, tov, signpostedAs, traversalTime, distance, steps, slope, wheelchairAccessible, mode));
    }

    public State[] traverse(State s0) {
        StateEditor s1 = this.createEditorForWalking(s0, this);
        if (s1 == null) {
            return State.empty();
        }
        RoutingPreferences preferences = s0.getPreferences();
        long time_ms = 1000L * (long)this.traversalTime;
        if (time_ms == 0L) {
            if (this.distance > 0.0) {
                time_ms = (long)(1000.0 * this.distance / preferences.walk().speed());
            } else if (this.isStairs()) {
                time_ms = (long)(400.0 * (double)Math.abs(this.steps) / preferences.walk().speed());
            }
        }
        if (time_ms > 0L) {
            double weight = (double)time_ms / 1000.0;
            weight = s0.getRequest().wheelchair() ? (weight *= StreetEdgeReluctanceCalculator.computeWheelchairReluctance(preferences, this.slope, this.wheelchairAccessible, this.isStairs())) : (weight *= StreetEdgeReluctanceCalculator.computeReluctance(preferences, TraverseMode.WALK, s0.currentMode() == TraverseMode.BICYCLE, this.isStairs()));
            s1.incrementTimeInMilliseconds(time_ms);
            s1.incrementWeight(weight);
        } else {
            s1.incrementWeight(1.0);
        }
        return s1.makeStateArray();
    }

    public Optional<I18NString> signpostedAs() {
        return Optional.ofNullable(this.signpostedAs);
    }

    @Override
    public I18NString getName() {
        return Objects.requireNonNullElse(this.signpostedAs, DEFAULT_NAME);
    }

    @Override
    public boolean nameIsDerived() {
        return this.signpostedAs == null;
    }

    @Override
    public LineString getGeometry() {
        Coordinate[] coordinates = new Coordinate[]{this.getFromVertex().getCoordinate(), this.getToVertex().getCoordinate()};
        return GeometryUtils.getGeometryFactory().createLineString(coordinates);
    }

    @Override
    public double getDistanceMeters() {
        return this.distance;
    }

    @Override
    public double getEffectiveWalkDistance() {
        if (this.traversalTime > 0) {
            return 0.0;
        }
        return this.distance;
    }

    public int getSteps() {
        return this.steps;
    }

    @Override
    public boolean isWheelchairAccessible() {
        return this.wheelchairAccessible;
    }

    public PathwayMode getMode() {
        return this.mode;
    }

    private boolean isStairs() {
        return this.steps > 0;
    }
}

