/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.street.model.edge;

import java.time.Duration;
import java.util.Optional;
import javax.annotation.Nullable;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.framework.geometry.GeometryUtils;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.framework.i18n.LocalizedString;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.street.search.TraverseMode;
import org.opentripplanner.street.search.state.State;
import org.opentripplanner.street.search.state.StateEditor;

public class EscalatorEdge
extends Edge {
    private static final LocalizedString NAME = new LocalizedString("name.escalator");
    private final double length;
    private final Duration duration;

    private EscalatorEdge(Vertex v1, Vertex v2, double length, Duration duration) {
        super(v1, v2);
        this.length = length;
        this.duration = duration;
    }

    public State[] traverse(State s0) {
        if (s0.currentMode() == TraverseMode.WALK && !s0.getRequest().wheelchair()) {
            StateEditor s1 = s0.edit(this);
            double time = this.duration == null ? this.getDistanceMeters() / s0.getPreferences().walk().escalator().speed() : (double)this.duration.toSeconds();
            s1.incrementWeight(s0.getPreferences().walk().escalator().reluctance() * time);
            s1.incrementTimeInSeconds((long)time);
            s1.incrementWalkDistance(this.getDistanceMeters());
            return s1.makeStateArray();
        }
        return State.empty();
    }

    @Override
    public LineString getGeometry() {
        return GeometryUtils.makeLineString(this.fromv.getCoordinate(), this.tov.getCoordinate());
    }

    @Override
    public double getDistanceMeters() {
        return this.length;
    }

    public Optional<Duration> getDuration() {
        return Optional.ofNullable(this.duration);
    }

    @Override
    public I18NString getName() {
        return NAME;
    }

    public static EscalatorEdge createEscalatorEdge(Vertex from, Vertex to, double length, @Nullable Duration duration) {
        return EscalatorEdge.connectToGraph(new EscalatorEdge(from, to, length, duration));
    }
}

