/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.street.model.edge;

import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.routing.api.request.preference.RoutingPreferences;
import org.opentripplanner.street.model.StreetTraversalPermission;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.edge.ElevatorEdge;
import org.opentripplanner.street.model.edge.WheelchairTraversalInformation;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.street.search.TraverseMode;
import org.opentripplanner.street.search.state.State;
import org.opentripplanner.street.search.state.StateEditor;
import org.opentripplanner.transit.model.basic.Accessibility;

public class ElevatorHopEdge
extends Edge
implements ElevatorEdge,
WheelchairTraversalInformation {
    private static final double DEFAULT_LEVELS = 1.0;
    private static final int DEFAULT_TRAVEL_TIME = 0;
    private final StreetTraversalPermission permission;
    private final Accessibility wheelchairAccessibility;
    private final double levels;
    private final int travelTime;

    private ElevatorHopEdge(Vertex from, Vertex to, StreetTraversalPermission permission, Accessibility wheelchairAccessibility, double levels, int travelTime) {
        super(from, to);
        this.permission = permission;
        this.wheelchairAccessibility = wheelchairAccessibility;
        this.levels = levels;
        this.travelTime = travelTime;
    }

    private ElevatorHopEdge(Vertex from, Vertex to, StreetTraversalPermission permission, Accessibility wheelchairAccessibility) {
        this(from, to, permission, wheelchairAccessibility, 1.0, 0);
    }

    public static void bidirectional(Vertex from, Vertex to, StreetTraversalPermission permission, Accessibility wheelchairBoarding, int levels, int travelTime) {
        ElevatorHopEdge.createElevatorHopEdge(from, to, permission, wheelchairBoarding, levels, travelTime);
        ElevatorHopEdge.createElevatorHopEdge(to, from, permission, wheelchairBoarding, levels, travelTime);
    }

    public static void bidirectional(Vertex from, Vertex to, StreetTraversalPermission permission, Accessibility wheelchairBoarding) {
        ElevatorHopEdge.createElevatorHopEdge(from, to, permission, wheelchairBoarding);
        ElevatorHopEdge.createElevatorHopEdge(to, from, permission, wheelchairBoarding);
    }

    public static ElevatorHopEdge createElevatorHopEdge(Vertex from, Vertex to, StreetTraversalPermission permission, Accessibility wheelchairAccessibility, double levels, int travelTime) {
        return ElevatorHopEdge.connectToGraph(new ElevatorHopEdge(from, to, permission, wheelchairAccessibility, levels, travelTime));
    }

    public static ElevatorHopEdge createElevatorHopEdge(Vertex from, Vertex to, StreetTraversalPermission permission, Accessibility wheelchairAccessibility) {
        return ElevatorHopEdge.connectToGraph(new ElevatorHopEdge(from, to, permission, wheelchairAccessibility));
    }

    public StreetTraversalPermission getPermission() {
        return this.permission;
    }

    public int getTravelTime() {
        return this.travelTime;
    }

    public State[] traverse(State s0) {
        TraverseMode mode;
        RoutingPreferences preferences = s0.getPreferences();
        StateEditor s1 = this.createEditorForDrivingOrWalking(s0, this);
        if (s0.getRequest().wheelchair()) {
            if (this.wheelchairAccessibility != Accessibility.POSSIBLE && preferences.wheelchair().elevator().onlyConsiderAccessible()) {
                return State.empty();
            }
            if (this.wheelchairAccessibility == Accessibility.NO_INFORMATION) {
                s1.incrementWeight(preferences.wheelchair().elevator().unknownCost());
            } else if (this.wheelchairAccessibility == Accessibility.NOT_POSSIBLE) {
                s1.incrementWeight(preferences.wheelchair().elevator().inaccessibleCost());
            }
        }
        if ((mode = s0.currentMode()) == TraverseMode.WALK && !this.permission.allows(StreetTraversalPermission.PEDESTRIAN)) {
            return State.empty();
        }
        if (mode == TraverseMode.BICYCLE && !this.permission.allows(StreetTraversalPermission.BICYCLE)) {
            return State.empty();
        }
        if (mode == TraverseMode.CAR && !this.permission.allows(StreetTraversalPermission.CAR)) {
            return State.empty();
        }
        s1.incrementWeight(this.travelTime > 0 ? (double)this.travelTime : (double)preferences.street().elevator().hopCost() * this.levels);
        int seconds = this.travelTime > 0 ? this.travelTime : (int)((double)preferences.street().elevator().hopTime() * this.levels);
        s1.incrementTimeInSeconds(seconds);
        return s1.makeStateArray();
    }

    @Override
    public I18NString getName() {
        return null;
    }

    @Override
    public boolean isWheelchairAccessible() {
        return this.wheelchairAccessibility == Accessibility.POSSIBLE;
    }
}

