/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.street.model.edge;

import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.framework.geometry.GeometryUtils;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.framework.i18n.NonLocalizedString;
import org.opentripplanner.routing.api.request.preference.StreetPreferences;
import org.opentripplanner.street.model.edge.BikeWalkableEdge;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.edge.ElevatorEdge;
import org.opentripplanner.street.model.vertex.ElevatorVertex;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.street.search.state.State;
import org.opentripplanner.street.search.state.StateEditor;

public class ElevatorBoardEdge
extends Edge
implements BikeWalkableEdge,
ElevatorEdge {
    private final LineString geometry;

    private ElevatorBoardEdge(Vertex from, ElevatorVertex to) {
        super(from, to);
        this.geometry = GeometryUtils.makeLineString(List.of(new Coordinate(from.getX(), from.getY()), new Coordinate(to.getX(), to.getY())));
    }

    public static ElevatorBoardEdge createElevatorBoardEdge(Vertex from, ElevatorVertex to) {
        return ElevatorBoardEdge.connectToGraph(new ElevatorBoardEdge(from, to));
    }

    public State[] traverse(State s0) {
        StateEditor s1 = this.createEditorForDrivingOrWalking(s0, this);
        if (s1 == null) {
            return State.empty();
        }
        StreetPreferences streetPreferences = s0.getPreferences().street();
        s1.incrementWeight(streetPreferences.elevator().boardCost());
        s1.incrementTimeInSeconds(streetPreferences.elevator().boardTime());
        return s1.makeStateArray();
    }

    @Override
    public I18NString getName() {
        return new NonLocalizedString("Elevator");
    }

    @Override
    public boolean nameIsDerived() {
        return true;
    }

    @Override
    public LineString getGeometry() {
        return this.geometry;
    }
}

