/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.street.model.edge;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.framework.geometry.GeometryUtils;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.street.model.edge.BikeWalkableEdge;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.edge.ElevatorEdge;
import org.opentripplanner.street.model.vertex.ElevatorVertex;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.street.search.state.State;
import org.opentripplanner.street.search.state.StateEditor;

public class ElevatorAlightEdge
extends Edge
implements BikeWalkableEdge,
ElevatorEdge {
    private final I18NString level;
    private final LineString the_geom;

    private ElevatorAlightEdge(ElevatorVertex from, Vertex to, I18NString level) {
        super(from, to);
        this.level = level;
        Coordinate[] coords = new Coordinate[]{new Coordinate(from.getX(), from.getY()), new Coordinate(to.getX(), to.getY())};
        this.the_geom = GeometryUtils.getGeometryFactory().createLineString(coords);
    }

    public static ElevatorAlightEdge createElevatorAlightEdge(ElevatorVertex from, Vertex to, I18NString level) {
        return ElevatorAlightEdge.connectToGraph(new ElevatorAlightEdge(from, to, level));
    }

    public State[] traverse(State s0) {
        StateEditor s1 = this.createEditorForDrivingOrWalking(s0, this);
        s1.incrementWeight(1.0);
        return s1.makeStateArray();
    }

    @Override
    public I18NString getName() {
        return this.level;
    }

    @Override
    public boolean nameIsDerived() {
        return false;
    }

    @Override
    public LineString getGeometry() {
        return this.the_geom;
    }

    @Override
    public double getDistanceMeters() {
        return 0.0;
    }
}

