/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.street.model.edge;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.astar.spi.AStarEdge;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.street.search.state.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Edge
implements AStarEdge<State, Edge, Vertex>,
Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(Edge.class);
    protected final Vertex fromv;
    protected final Vertex tov;

    protected Edge(Vertex v1, Vertex v2) {
        if (v1 == null || v2 == null) {
            String err = String.format("%s constructed with null vertex : %s %s", this.getClass(), v1, v2);
            throw new IllegalStateException(err);
        }
        this.fromv = v1;
        this.tov = v2;
    }

    @Override
    public final Vertex getFromVertex() {
        return this.fromv;
    }

    @Override
    public final Vertex getToVertex() {
        return this.tov;
    }

    public boolean isEquivalentTo(Edge e) {
        return this == e;
    }

    public final boolean isReverseOf(Edge e) {
        return this.getFromVertex().getParent() == e.getToVertex().getParent() && this.getToVertex().getParent() == e.getFromVertex().getParent();
    }

    public boolean isReachableFromGraph() {
        boolean edgeReachableFromGraph = this.tov.getIncoming().contains(this);
        if (!edgeReachableFromGraph) {
            LOG.warn("Edge {} returned from spatial index is no longer reachable from graph. That is not expected.", (Object)this);
        }
        return edgeReachableFromGraph;
    }

    public int hashCode() {
        return Objects.hash(this.fromv, this.tov);
    }

    public String toString() {
        return this.buildToString(null, b -> {});
    }

    protected String buildToString(@Nullable String name, Consumer<StringBuilder> body) {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getSimpleName()).append("(");
        if (name != null) {
            buf.append(name).append(", ");
        }
        buf.append(this.fromv).append(" -> ").append(this.tov);
        body.accept(buf);
        return buf.append(')').toString();
    }

    public boolean isRoundabout() {
        return false;
    }

    public String getDefaultName() {
        I18NString name = this.getName();
        return name != null ? name.toString() : null;
    }

    public abstract I18NString getName();

    public boolean nameIsDerived() {
        return false;
    }

    public LineString getGeometry() {
        return null;
    }

    public boolean hasGeometry() {
        return this.getGeometry() != null;
    }

    public double getDistanceMeters() {
        return 0.0;
    }

    public double getEffectiveWalkDistance() {
        return 0.0;
    }

    public void remove() {
        this.fromv.removeOutgoing(this);
        this.tov.removeIncoming(this);
    }

    protected void connectToGraph() {
        this.fromv.addOutgoing(this);
        this.tov.addIncoming(this);
    }

    protected static <T extends Edge> T connectToGraph(T edge) {
        edge.connectToGraph();
        return edge;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.connectToGraph();
    }

    private void writeObject(ObjectOutputStream out) throws IOException, ClassNotFoundException {
        out.defaultWriteObject();
    }
}

