/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.street.model.edge;

import java.util.List;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.framework.geometry.GeometryUtils;
import org.opentripplanner.street.model.edge.StreetTransitEntityLink;
import org.opentripplanner.street.model.vertex.StreetVertex;
import org.opentripplanner.street.model.vertex.TransitStopVertex;

public class BoardingLocationToStopLink
extends StreetTransitEntityLink<TransitStopVertex> {
    private BoardingLocationToStopLink(StreetVertex fromv, TransitStopVertex tov) {
        super(fromv, tov, tov.getWheelchairAccessibility());
    }

    private BoardingLocationToStopLink(TransitStopVertex fromv, StreetVertex tov) {
        super(fromv, tov, fromv.getWheelchairAccessibility());
    }

    public static BoardingLocationToStopLink createBoardingLocationToStopLink(StreetVertex fromv, TransitStopVertex tov) {
        return BoardingLocationToStopLink.connectToGraph(new BoardingLocationToStopLink(fromv, tov));
    }

    public static BoardingLocationToStopLink createBoardingLocationToStopLink(TransitStopVertex fromv, StreetVertex tov) {
        return BoardingLocationToStopLink.connectToGraph(new BoardingLocationToStopLink(fromv, tov));
    }

    @Override
    protected int getStreetToStopTime() {
        return 0;
    }

    @Override
    public LineString getGeometry() {
        return GeometryUtils.makeLineString(List.of(this.fromv.getCoordinate(), this.tov.getCoordinate()));
    }
}

