/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.street.model.edge;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.opentripplanner.street.model.edge.Area;
import org.opentripplanner.street.model.vertex.IntersectionVertex;

public class AreaGroup
implements Serializable {
    private static final Set<IntersectionVertex> EMPTY_SET = Set.of();
    private Set<IntersectionVertex> visibilityVertices = EMPTY_SET;
    private final Polygon geometry;
    private final List<Area> areas = new ArrayList<Area>();

    public AreaGroup(Polygon geometry) {
        this.geometry = geometry;
    }

    public String toString() {
        return String.format("AreaGroup: visibilityVertices=%s, %s", this.visibilityVertices, this.geometry);
    }

    public void addArea(Area area) {
        this.areas.add(area);
    }

    public List<Area> getAreas() {
        return this.areas;
    }

    public Geometry getGeometry() {
        return this.geometry;
    }

    public Set<IntersectionVertex> visibilityVertices() {
        return this.visibilityVertices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVisibilityVertices(Set<IntersectionVertex> toAdd) {
        AreaGroup areaGroup = this;
        synchronized (areaGroup) {
            if (this.visibilityVertices == EMPTY_SET) {
                this.visibilityVertices = Set.copyOf(toAdd);
            } else {
                HashSet<IntersectionVertex> temp = new HashSet<IntersectionVertex>(this.visibilityVertices);
                temp.addAll(toAdd);
                this.visibilityVertices = Set.copyOf(temp);
            }
        }
    }
}

