/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.server;

import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.regex.Pattern;
import org.opentripplanner.framework.application.LogMDCSupport;
import org.opentripplanner.standalone.server.RequestTraceParameter;
import org.opentripplanner.utils.lang.StringUtils;

public class RequestTraceFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final String MIN_ID_BASE = "1000000";
    private static final long MIN_ID = Long.parseLong("1000000", 36);
    private static final long MAX_ID = Long.parseLong("10000000", 36);
    private static final Random ID_GEN = new Random(new SecureRandom().nextLong());
    static final Pattern HTTP_HEADER_VALUE_CHECK = Pattern.compile("[^\\p{Cntrl}\\v]{1,512}");
    private static List<RequestTraceParameter> traceParameters;

    public static void init(List<RequestTraceParameter> parameters) {
        ArrayList<RequestTraceParameter> copy = new ArrayList<RequestTraceParameter>(parameters);
        Collections.reverse(copy);
        traceParameters = List.copyOf(copy);
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        for (RequestTraceParameter it : traceParameters) {
            if (!it.hasLogKey()) continue;
            String value = null;
            if (it.hasHttpRequestHeader()) {
                value = RequestTraceFilter.retrieveHTTPHeaderValue(requestContext, it.httpRequestHeader());
            }
            if (value == null && it.generateIdIfMissing()) {
                value = RequestTraceFilter.generateUniqueId();
            }
            LogMDCSupport.putLocal(it.logKey(), value);
        }
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        for (RequestTraceParameter it : traceParameters) {
            if (it.hasHttpResponseHeader()) {
                String value = this.resolveValueForResponse(it, requestContext);
                this.setHttpResponseHeaderValue(responseContext, it.httpResponseHeader(), value);
            }
            if (!it.hasLogKey()) continue;
            LogMDCSupport.removeLocal(it.logKey());
        }
    }

    private String resolveValueForResponse(RequestTraceParameter p, ContainerRequestContext requestContext) {
        String value = null;
        if (p.hasHttpRequestHeader()) {
            value = RequestTraceFilter.retrieveHTTPHeaderValue(requestContext, p.httpRequestHeader());
        }
        if (value == null && p.hasLogKey()) {
            value = LogMDCSupport.getLocalValue(p.logKey());
        }
        if (value == null && p.generateIdIfMissing()) {
            value = RequestTraceFilter.generateUniqueId();
        }
        return value;
    }

    private void setHttpResponseHeaderValue(ContainerResponseContext responseContext, String header, String value) {
        if (StringUtils.hasValue((String)value)) {
            responseContext.getHeaders().add((Object)header, (Object)value);
        }
    }

    private static String generateUniqueId() {
        long v = ID_GEN.nextLong(MIN_ID, MAX_ID);
        return Long.toString(v, 36);
    }

    private static String retrieveHTTPHeaderValue(ContainerRequestContext requestContext, String httpHeader) {
        String value = requestContext.getHeaderString(httpHeader);
        if (StringUtils.hasNoValue((String)value)) {
            return null;
        }
        return HTTP_HEADER_VALUE_CHECK.matcher(value).matches() ? value : null;
    }
}

