/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.server;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.binder.jersey.server.DefaultJerseyTagsProvider;
import io.micrometer.core.instrument.binder.jersey.server.JerseyTagsProvider;
import io.micrometer.core.instrument.binder.jersey.server.MetricsApplicationEventListener;
import io.micrometer.prometheusmetrics.PrometheusConfig;
import io.micrometer.prometheusmetrics.PrometheusMeterRegistry;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.core.Application;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.Binder;
import org.glassfish.jersey.jackson.internal.jackson.jaxrs.json.JacksonJsonProvider;
import org.opentripplanner.api.common.OTPExceptionMapper;
import org.opentripplanner.apis.APIEndpoints;
import org.opentripplanner.framework.application.OTPFeature;
import org.opentripplanner.standalone.api.OtpServerRequestContext;
import org.opentripplanner.standalone.server.CorsFilter;
import org.opentripplanner.standalone.server.EtagRequestFilter;
import org.opentripplanner.standalone.server.OTPWebApplicationParameters;
import org.opentripplanner.standalone.server.RequestTraceFilter;
import org.opentripplanner.standalone.server.RequestTraceParameter;
import org.opentripplanner.standalone.server.VaryRequestFilter;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class OTPWebApplication
extends Application {
    private final Supplier<OtpServerRequestContext> contextProvider;
    private final List<Class<? extends ContainerResponseFilter>> customFilters;

    public OTPWebApplication(OTPWebApplicationParameters parameters, Supplier<OtpServerRequestContext> contextProvider) {
        this.contextProvider = contextProvider;
        this.customFilters = this.createCustomFilters(parameters.traceParameters());
    }

    public Set<Class<?>> getClasses() {
        HashSet classes = new HashSet(APIEndpoints.listAPIEndpoints());
        classes.addAll(this.resolveFilterClasses());
        return classes;
    }

    private Set<Class<? extends ContainerResponseFilter>> resolveFilterClasses() {
        HashSet<Class<? extends ContainerResponseFilter>> set = new HashSet<Class<? extends ContainerResponseFilter>>();
        set.addAll(this.customFilters);
        set.add(CorsFilter.class);
        set.add(EtagRequestFilter.class);
        set.add(VaryRequestFilter.class);
        return set;
    }

    public Set<Object> getSingletons() {
        HashSet<MetricsApplicationEventListener> singletons = new HashSet<MetricsApplicationEventListener>(List.of(new OTPExceptionMapper(), new JacksonJsonProvider(), this.makeBinder(this.contextProvider), this.getMetricsApplicationEventListener()));
        if (OTPFeature.ActuatorAPI.isOn()) {
            singletons.add((MetricsApplicationEventListener)this.getBoundPrometheusRegistry());
        }
        return singletons;
    }

    public Map<String, Object> getProperties() {
        return Map.of("jersey.config.disableAutoDiscovery", Boolean.TRUE);
    }

    private Binder makeBinder(final Supplier<OtpServerRequestContext> contextProvider) {
        return new AbstractBinder(this){

            protected void configure() {
                this.bindFactory(contextProvider).to(OtpServerRequestContext.class);
            }
        };
    }

    private MetricsApplicationEventListener getMetricsApplicationEventListener() {
        return new MetricsApplicationEventListener((MeterRegistry)Metrics.globalRegistry, (JerseyTagsProvider)new DefaultJerseyTagsProvider(), "http.server.requests", true);
    }

    private Binder getBoundPrometheusRegistry() {
        final PrometheusMeterRegistry prometheusRegistry = new PrometheusMeterRegistry(PrometheusConfig.DEFAULT);
        Metrics.globalRegistry.add((MeterRegistry)prometheusRegistry);
        return new AbstractBinder(this){

            protected void configure() {
                this.bind(prometheusRegistry).to(PrometheusMeterRegistry.class);
            }
        };
    }

    private List<Class<? extends ContainerResponseFilter>> createCustomFilters(List<RequestTraceParameter> traceParameters) {
        if (traceParameters.isEmpty()) {
            return List.of();
        }
        RequestTraceFilter.init(traceParameters);
        return List.of(RequestTraceFilter.class);
    }

    static {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
    }
}

