/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.server;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import jakarta.ws.rs.core.Application;
import java.io.IOException;
import java.net.BindException;
import java.time.Duration;
import java.util.Optional;
import org.glassfish.grizzly.http.CompressionConfig;
import org.glassfish.grizzly.http.server.CLStaticHttpHandler;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.NetworkListener;
import org.glassfish.grizzly.http.server.StaticHttpHandler;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;
import org.glassfish.jersey.server.ContainerFactory;
import org.opentripplanner.framework.application.ApplicationShutdownSupport;
import org.opentripplanner.framework.application.OTPFeature;
import org.opentripplanner.standalone.config.CommandLineParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class GrizzlyServer {
    private static final Logger LOG = LoggerFactory.getLogger(GrizzlyServer.class);
    private static final int MIN_THREADS = 4;
    private final CommandLineParameters params;
    private final Application app;
    private final Duration httpTransactionTimeout;

    public GrizzlyServer(CommandLineParameters params, Application app, Duration httpTransactionTimeout) {
        this.params = params;
        this.app = app;
        this.httpTransactionTimeout = httpTransactionTimeout;
    }

    public void run() {
        LOG.info("Starting OTP Grizzly server on port {} of interface {}", (Object)this.params.port, (Object)this.params.bindAddress);
        LOG.info("OTP server base directory is: {}", this.params.baseDirectory);
        HttpServer httpServer = new HttpServer();
        int nHandlerThreads = this.getMaxThreads();
        ThreadPoolConfig threadPoolConfig = ThreadPoolConfig.defaultConfig().setPoolName("grizzly").setThreadFactory(new ThreadFactoryBuilder().setNameFormat("grizzly-%d").build()).setCorePoolSize(nHandlerThreads).setMaxPoolSize(nHandlerThreads).setQueueLimit(-1);
        NetworkListener httpListener = new NetworkListener("otp_insecure", this.params.bindAddress, this.params.port.intValue());
        httpListener.setSecure(false);
        CompressionConfig cc = httpListener.getCompressionConfig();
        cc.setCompressionMode(CompressionConfig.CompressionMode.ON);
        cc.setCompressionMinSize(50000);
        cc.setCompressibleMimeTypes(new String[]{"application/json", "application/xml"});
        httpListener.getTransport().setWorkerThreadPoolConfig(threadPoolConfig);
        httpListener.setTransactionTimeout((int)this.httpTransactionTimeout.toSeconds());
        httpServer.addListener(httpListener);
        HttpHandler dynamicHandler = (HttpHandler)ContainerFactory.createContainer(HttpHandler.class, (Application)this.app);
        httpServer.getServerConfiguration().addHttpHandler(dynamicHandler, new String[]{"/otp/"});
        if (OTPFeature.DebugUi.isOn()) {
            CLStaticHttpHandler staticHandler = new CLStaticHttpHandler(GrizzlyServer.class.getClassLoader(), new String[]{"/client/"});
            if (this.params.disableFileCache) {
                LOG.info("Disabling HTTP server static file cache.");
                staticHandler.setFileCacheEnabled(false);
            }
            httpServer.getServerConfiguration().addHttpHandler((HttpHandler)staticHandler, new String[]{"/"});
        }
        if (this.params.clientDirectory != null) {
            StaticHttpHandler localHandler = new StaticHttpHandler(new String[]{this.params.clientDirectory.getAbsolutePath()});
            localHandler.setFileCacheEnabled(false);
            httpServer.getServerConfiguration().addHttpHandler((HttpHandler)localHandler, new String[]{"/local"});
        }
        Optional<Thread> shutdownThread = ApplicationShutdownSupport.addShutdownHook("grizzly-shutdown", () -> ((HttpServer)httpServer).shutdown());
        if (!shutdownThread.isPresent()) {
            return;
        }
        try {
            httpServer.start();
            LOG.info("Grizzly server running.");
            Thread.currentThread().join();
        }
        catch (BindException be) {
            LOG.error("Cannot bind to port {}. Is it already in use?", (Object)this.params.port);
        }
        catch (IOException ioe) {
            LOG.error("IO exception while starting server.");
        }
        catch (InterruptedException ie) {
            LOG.info("Interrupted, shutting down.");
        }
        shutdownThread.ifPresent(thread -> ApplicationShutdownSupport.removeShutdownHook(thread));
        httpServer.shutdown();
    }

    private int getMaxThreads() {
        int maxThreads = Runtime.getRuntime().availableProcessors();
        LOG.info("Java reports that this machine has {} available processors.", (Object)maxThreads);
        maxThreads = (int)((double)maxThreads * 1.25);
        if (this.params.maxThreads != null) {
            maxThreads = this.params.maxThreads;
            LOG.info("Based on configuration, forced max thread pool size to {} threads.", (Object)maxThreads);
        }
        if (maxThreads < 4) {
            maxThreads = 4;
        }
        LOG.info("Maximum HTTP handler thread pool size will be {} threads.", (Object)maxThreads);
        return maxThreads;
    }

    static {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
    }
}

