/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMultimap;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.MultiGauge;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.opentripplanner.framework.application.ApplicationShutdownSupport;
import org.opentripplanner.routing.alertpatch.AlertCause;
import org.opentripplanner.routing.alertpatch.AlertEffect;
import org.opentripplanner.routing.alertpatch.AlertSeverity;
import org.opentripplanner.routing.alertpatch.TransitAlert;
import org.opentripplanner.routing.services.TransitAlertService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlertMetrics
implements MeterBinder {
    private static final Logger LOG = LoggerFactory.getLogger(AlertMetrics.class);
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private final Supplier<TransitAlertService> serviceSupplier;
    private MultiGauge statuses;

    public AlertMetrics(Supplier<TransitAlertService> serviceSupplier) {
        this.serviceSupplier = serviceSupplier;
        this.scheduler.scheduleWithFixedDelay(this::recordMetrics, 0L, 30L, TimeUnit.SECONDS);
    }

    public void bindTo(MeterRegistry meterRegistry) {
        this.statuses = MultiGauge.builder((String)"alerts").description("Total number of alerts (sourced from GTFS-Alerts and SIRI-SX) in the system.").register(meterRegistry);
        ApplicationShutdownSupport.addShutdownHook("alert-metrics-shutdown", this.scheduler::shutdownNow);
    }

    @VisibleForTesting
    void recordMetrics() {
        try {
            TransitAlertService transitAlertService = this.serviceSupplier.get();
            if (transitAlertService != null && this.statuses != null) {
                Iterable<MultiGauge.Row<Number>> rows = this.summarizeAlerts(transitAlertService);
                this.statuses.register(rows, true);
            }
        }
        catch (Exception e) {
            LOG.error("Error building alerts metrics", (Throwable)e);
        }
    }

    private Iterable<MultiGauge.Row<Number>> summarizeAlerts(TransitAlertService alertService) {
        Collection<TransitAlert> alerts = alertService.getAllAlerts();
        ImmutableMultimap taggedAlerts = (ImmutableMultimap)alerts.stream().collect(ImmutableListMultimap.flatteningToImmutableListMultimap(AlertTags::of, Stream::of));
        return taggedAlerts.keySet().stream().map(alertTags -> {
            Tags tags = alertTags.toTags();
            int count = taggedAlerts.get(alertTags).size();
            return MultiGauge.Row.of((Tags)tags, (Number)count);
        }).toList();
    }

    record AlertTags(String feedId, String siriCodespace, AlertSeverity severity, AlertEffect effect, AlertCause cause) {
        static AlertTags of(TransitAlert a) {
            return new AlertTags(a.getId().getFeedId(), a.siriCodespace(), a.severity(), a.effect(), a.cause());
        }

        Tags toTags() {
            ArrayList<Tag> tags = new ArrayList<Tag>(5);
            tags.add(Tag.of((String)"feedId", (String)this.feedId));
            if (this.siriCodespace != null) {
                tags.add(Tag.of((String)"siriCodespace", (String)this.siriCodespace));
            }
            if (this.severity != null) {
                tags.add(Tag.of((String)"severity", (String)this.severity.name()));
            }
            if (this.effect != null) {
                tags.add(Tag.of((String)"effect", (String)this.effect.name()));
            }
            if (this.cause != null) {
                tags.add(Tag.of((String)"cause", (String)this.cause.name()));
            }
            return Tags.of(tags);
        }
    }
}

