/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.configure;

import javax.annotation.Nullable;
import org.opentripplanner.datastore.api.DataSource;
import org.opentripplanner.ext.emission.EmissionRepository;
import org.opentripplanner.ext.stopconsolidation.StopConsolidationRepository;
import org.opentripplanner.graph_builder.GraphBuilderDataSources;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueSummary;
import org.opentripplanner.routing.fares.FareServiceFactory;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graph.SerializedGraphObject;
import org.opentripplanner.service.osminfo.OsmInfoGraphBuildRepository;
import org.opentripplanner.service.vehicleparking.VehicleParkingRepository;
import org.opentripplanner.service.worldenvelope.WorldEnvelopeRepository;
import org.opentripplanner.standalone.config.CommandLineParameters;
import org.opentripplanner.standalone.config.ConfigModel;
import org.opentripplanner.standalone.configure.ConstructApplication;
import org.opentripplanner.standalone.configure.DaggerLoadApplicationFactory;
import org.opentripplanner.standalone.configure.LoadApplicationFactory;
import org.opentripplanner.street.model.StreetLimitationParameters;
import org.opentripplanner.transit.service.TimetableRepository;

public class LoadApplication {
    private final CommandLineParameters cli;
    private final LoadApplicationFactory factory;
    private boolean dataStoreLoaded = false;

    public LoadApplication(CommandLineParameters commandLineParameters) {
        this.cli = commandLineParameters;
        this.factory = DaggerLoadApplicationFactory.builder().commandLineParameters(this.cli).build();
    }

    public void validateConfigAndDataSources() {
        this.factory.graphBuilderDataSources();
        this.dataStoreLoaded = true;
    }

    public DataSource getInputGraphDataStore() {
        return this.cli.doLoadGraph() ? this.factory.datastore().getGraph() : this.factory.datastore().getStreetGraph();
    }

    public ConstructApplication appConstruction(SerializedGraphObject obj) {
        return this.createAppConstruction(obj.graph, obj.osmInfoGraphBuildRepository, obj.timetableRepository, obj.worldEnvelopeRepository, obj.parkingRepository, obj.issueSummary, obj.emissionRepository, obj.stopConsolidationRepository, obj.streetLimitationParameters, obj.fareServiceFactory);
    }

    public ConstructApplication appConstruction() {
        return this.createAppConstruction(this.factory.emptyGraph(), this.factory.emptyOsmInfoGraphBuildRepository(), this.factory.emptyTimetableRepository(), this.factory.emptyWorldEnvelopeRepository(), this.factory.emptyVehicleParkingRepository(), DataImportIssueSummary.empty(), this.factory.emptyEmissionsDataModel(), this.factory.emptyStopConsolidationRepository(), this.factory.emptyStreetLimitationParameters(), this.factory.emptyFareServiceFactory());
    }

    public GraphBuilderDataSources graphBuilderDataSources() {
        if (!this.dataStoreLoaded) {
            throw new IllegalStateException("Validate graphBuilderDataSources before using it");
        }
        return this.factory.graphBuilderDataSources();
    }

    public ConfigModel config() {
        return this.factory.configModel();
    }

    private ConstructApplication createAppConstruction(Graph graph, OsmInfoGraphBuildRepository osmInfoGraphBuildRepository, TimetableRepository timetableRepository, WorldEnvelopeRepository worldEnvelopeRepository, VehicleParkingRepository parkingRepository, DataImportIssueSummary issueSummary, @Nullable EmissionRepository emissionRepository, @Nullable StopConsolidationRepository stopConsolidationRepository, StreetLimitationParameters streetLimitationParameters, FareServiceFactory fareServiceFactory) {
        return new ConstructApplication(this.cli, graph, osmInfoGraphBuildRepository, timetableRepository, worldEnvelopeRepository, this.config(), this.graphBuilderDataSources(), issueSummary, emissionRepository, parkingRepository, stopConsolidationRepository, streetLimitationParameters, fareServiceFactory);
    }
}

