/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.configure;

import dagger.internal.DaggerGenerated;
import dagger.internal.DoubleCheck;
import dagger.internal.InstanceFactory;
import dagger.internal.Preconditions;
import dagger.internal.Provider;
import java.io.File;
import org.opentripplanner.datastore.OtpDataStore;
import org.opentripplanner.datastore.api.OtpDataStoreConfig;
import org.opentripplanner.datastore.base.DataSourceRepository;
import org.opentripplanner.datastore.configure.DataStoreModule_ProvideDataStoreFactory;
import org.opentripplanner.ext.datastore.gs.GsDataSourceModule;
import org.opentripplanner.ext.datastore.gs.GsDataSourceModule_ProvideGoogleStorageDataSourceRepositoryFactory;
import org.opentripplanner.ext.emission.EmissionRepository;
import org.opentripplanner.ext.emission.configure.EmissionRepositoryModule_ProvideEmissionRepositoryFactory;
import org.opentripplanner.ext.fares.configure.FareModule;
import org.opentripplanner.ext.fares.configure.FareModule_FactoryFactory;
import org.opentripplanner.ext.stopconsolidation.StopConsolidationRepository;
import org.opentripplanner.ext.stopconsolidation.internal.DefaultStopConsolidationRepository;
import org.opentripplanner.ext.stopconsolidation.internal.DefaultStopConsolidationRepository_Factory;
import org.opentripplanner.graph_builder.GraphBuilderDataSources;
import org.opentripplanner.graph_builder.GraphBuilderDataSources_Factory;
import org.opentripplanner.model.calendar.ServiceDateInterval;
import org.opentripplanner.model.calendar.openinghours.OpeningHoursCalendarService;
import org.opentripplanner.routing.fares.FareServiceFactory;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.service.osminfo.OsmInfoGraphBuildRepository;
import org.opentripplanner.service.osminfo.internal.DefaultOsmInfoGraphBuildRepository;
import org.opentripplanner.service.vehicleparking.VehicleParkingRepository;
import org.opentripplanner.service.vehicleparking.internal.DefaultVehicleParkingRepository;
import org.opentripplanner.service.vehicleparking.internal.DefaultVehicleParkingRepository_Factory;
import org.opentripplanner.service.worldenvelope.WorldEnvelopeRepository;
import org.opentripplanner.service.worldenvelope.internal.DefaultWorldEnvelopeRepository;
import org.opentripplanner.service.worldenvelope.internal.DefaultWorldEnvelopeRepository_Factory;
import org.opentripplanner.standalone.config.BuildConfig;
import org.opentripplanner.standalone.config.CommandLineParameters;
import org.opentripplanner.standalone.config.ConfigModel;
import org.opentripplanner.standalone.config.OtpConfigLoader;
import org.opentripplanner.standalone.config.configure.ConfigModule_ProvideBuildConfigFactory;
import org.opentripplanner.standalone.config.configure.LoadConfigModule_BaseDirectoryFactory;
import org.opentripplanner.standalone.config.configure.LoadConfigModule_ProvidesConfigLoaderFactory;
import org.opentripplanner.standalone.config.configure.LoadConfigModule_ProvidesDataStoreConfigFactory;
import org.opentripplanner.standalone.config.configure.LoadConfigModule_ProvidesModelFactory;
import org.opentripplanner.standalone.config.configure.LoadConfigModule_ProvidesTransitServicePeriodFactory;
import org.opentripplanner.standalone.configure.LoadApplicationFactory;
import org.opentripplanner.street.model.StreetLimitationParameters;
import org.opentripplanner.transit.model.framework.Deduplicator;
import org.opentripplanner.transit.service.SiteRepository;
import org.opentripplanner.transit.service.TimetableRepository;

@DaggerGenerated
public final class DaggerLoadApplicationFactory {
    private DaggerLoadApplicationFactory() {
    }

    public static LoadApplicationFactory.Builder builder() {
        return new Builder();
    }

    private static final class Builder
    implements LoadApplicationFactory.Builder {
        private CommandLineParameters commandLineParameters;

        private Builder() {
        }

        @Override
        public Builder commandLineParameters(CommandLineParameters cli) {
            this.commandLineParameters = (CommandLineParameters)Preconditions.checkNotNull((Object)cli);
            return this;
        }

        @Override
        public LoadApplicationFactory build() {
            Preconditions.checkBuilderRequirement((Object)this.commandLineParameters, CommandLineParameters.class);
            return new LoadApplicationFactoryImpl(new GsDataSourceModule(), new FareModule(), this.commandLineParameters);
        }
    }

    private static final class LoadApplicationFactoryImpl
    implements LoadApplicationFactory {
        private final LoadApplicationFactoryImpl loadApplicationFactoryImpl = this;
        Provider<CommandLineParameters> commandLineParametersProvider;
        Provider<File> baseDirectoryProvider;
        Provider<OtpConfigLoader> providesConfigLoaderProvider;
        Provider<ConfigModel> providesModelProvider;
        Provider<BuildConfig> provideBuildConfigProvider;
        Provider<OtpDataStoreConfig> providesDataStoreConfigProvider;
        Provider<DataSourceRepository> provideGoogleStorageDataSourceRepositoryProvider;
        Provider<OtpDataStore> provideDataStoreProvider;
        Provider<DefaultWorldEnvelopeRepository> defaultWorldEnvelopeRepositoryProvider;
        Provider<GraphBuilderDataSources> graphBuilderDataSourcesProvider;
        Provider<EmissionRepository> provideEmissionRepositoryProvider;
        Provider<DefaultStopConsolidationRepository> defaultStopConsolidationRepositoryProvider;
        Provider<FareServiceFactory> factoryProvider;
        Provider<DefaultVehicleParkingRepository> defaultVehicleParkingRepositoryProvider;

        LoadApplicationFactoryImpl(GsDataSourceModule gsDataSourceModuleParam, FareModule fareModuleParam, CommandLineParameters commandLineParametersParam) {
            this.initialize(gsDataSourceModuleParam, fareModuleParam, commandLineParametersParam);
        }

        BuildConfig buildConfig() {
            return ConfigModule_ProvideBuildConfigFactory.provideBuildConfig((ConfigModel)this.providesModelProvider.get());
        }

        ServiceDateInterval transitServicePeriodServiceDateInterval() {
            return LoadConfigModule_ProvidesTransitServicePeriodFactory.providesTransitServicePeriod(this.buildConfig());
        }

        OpeningHoursCalendarService openingHoursCalendarService() {
            return new OpeningHoursCalendarService(new Deduplicator(), this.transitServicePeriodServiceDateInterval());
        }

        private void initialize(GsDataSourceModule gsDataSourceModuleParam, FareModule fareModuleParam, CommandLineParameters commandLineParametersParam) {
            this.commandLineParametersProvider = InstanceFactory.create((Object)commandLineParametersParam);
            this.baseDirectoryProvider = LoadConfigModule_BaseDirectoryFactory.create(this.commandLineParametersProvider);
            this.providesConfigLoaderProvider = LoadConfigModule_ProvidesConfigLoaderFactory.create(this.baseDirectoryProvider);
            this.providesModelProvider = DoubleCheck.provider((Provider)LoadConfigModule_ProvidesModelFactory.create(this.providesConfigLoaderProvider));
            this.provideBuildConfigProvider = ConfigModule_ProvideBuildConfigFactory.create(this.providesModelProvider);
            this.providesDataStoreConfigProvider = LoadConfigModule_ProvidesDataStoreConfigFactory.create(this.provideBuildConfigProvider);
            this.provideGoogleStorageDataSourceRepositoryProvider = DoubleCheck.provider((Provider)GsDataSourceModule_ProvideGoogleStorageDataSourceRepositoryFactory.create(gsDataSourceModuleParam, this.providesDataStoreConfigProvider));
            this.provideDataStoreProvider = DoubleCheck.provider((Provider)DataStoreModule_ProvideDataStoreFactory.create(this.baseDirectoryProvider, this.providesDataStoreConfigProvider, this.provideGoogleStorageDataSourceRepositoryProvider));
            this.defaultWorldEnvelopeRepositoryProvider = DoubleCheck.provider((Provider)DefaultWorldEnvelopeRepository_Factory.create());
            this.graphBuilderDataSourcesProvider = DoubleCheck.provider((Provider)GraphBuilderDataSources_Factory.create(this.commandLineParametersProvider, this.provideBuildConfigProvider, this.provideDataStoreProvider, this.baseDirectoryProvider));
            this.provideEmissionRepositoryProvider = DoubleCheck.provider((Provider)EmissionRepositoryModule_ProvideEmissionRepositoryFactory.create(this.provideBuildConfigProvider));
            this.defaultStopConsolidationRepositoryProvider = DoubleCheck.provider((Provider)DefaultStopConsolidationRepository_Factory.create());
            this.factoryProvider = DoubleCheck.provider((Provider)FareModule_FactoryFactory.create(fareModuleParam, this.provideBuildConfigProvider));
            this.defaultVehicleParkingRepositoryProvider = DoubleCheck.provider((Provider)DefaultVehicleParkingRepository_Factory.create());
        }

        @Override
        public OtpDataStore datastore() {
            return (OtpDataStore)this.provideDataStoreProvider.get();
        }

        @Override
        public ConfigModel configModel() {
            return (ConfigModel)this.providesModelProvider.get();
        }

        @Override
        public Graph emptyGraph() {
            return new Graph(new Deduplicator(), this.openingHoursCalendarService());
        }

        @Override
        public OsmInfoGraphBuildRepository emptyOsmInfoGraphBuildRepository() {
            return new DefaultOsmInfoGraphBuildRepository();
        }

        @Override
        public TimetableRepository emptyTimetableRepository() {
            return new TimetableRepository(new SiteRepository(), new Deduplicator());
        }

        @Override
        public WorldEnvelopeRepository emptyWorldEnvelopeRepository() {
            return (WorldEnvelopeRepository)this.defaultWorldEnvelopeRepositoryProvider.get();
        }

        @Override
        public GraphBuilderDataSources graphBuilderDataSources() {
            return (GraphBuilderDataSources)this.graphBuilderDataSourcesProvider.get();
        }

        @Override
        public EmissionRepository emptyEmissionsDataModel() {
            return (EmissionRepository)this.provideEmissionRepositoryProvider.get();
        }

        @Override
        public StopConsolidationRepository emptyStopConsolidationRepository() {
            return (StopConsolidationRepository)this.defaultStopConsolidationRepositoryProvider.get();
        }

        @Override
        public StreetLimitationParameters emptyStreetLimitationParameters() {
            return new StreetLimitationParameters();
        }

        @Override
        public FareServiceFactory emptyFareServiceFactory() {
            return (FareServiceFactory)this.factoryProvider.get();
        }

        @Override
        public VehicleParkingRepository emptyVehicleParkingRepository() {
            return (VehicleParkingRepository)this.defaultVehicleParkingRepositoryProvider.get();
        }
    }
}

