/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.configure;

import dagger.Module;
import dagger.Provides;
import graphql.schema.GraphQLSchema;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import jakarta.inject.Singleton;
import java.util.List;
import javax.annotation.Nullable;
import org.opentripplanner.apis.gtfs.GtfsApiParameters;
import org.opentripplanner.apis.gtfs.configure.GtfsSchema;
import org.opentripplanner.apis.transmodel.configure.TransmodelSchema;
import org.opentripplanner.astar.spi.TraverseVisitor;
import org.opentripplanner.ext.flex.FlexParameters;
import org.opentripplanner.ext.geocoder.LuceneIndex;
import org.opentripplanner.ext.interactivelauncher.api.LauncherRequestDecorator;
import org.opentripplanner.ext.ridehailing.RideHailingService;
import org.opentripplanner.ext.sorlandsbanen.SorlandsbanenNorwayService;
import org.opentripplanner.ext.stopconsolidation.StopConsolidationService;
import org.opentripplanner.ext.trias.parameters.TriasApiParameters;
import org.opentripplanner.raptor.configure.RaptorConfig;
import org.opentripplanner.routing.algorithm.filterchain.ext.EmissionDecorator;
import org.opentripplanner.routing.algorithm.filterchain.framework.spi.ItineraryDecorator;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripSchedule;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.fares.FareService;
import org.opentripplanner.routing.fares.FareServiceFactory;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.linking.VertexLinker;
import org.opentripplanner.routing.via.ViaCoordinateTransferFactory;
import org.opentripplanner.service.realtimevehicles.RealtimeVehicleService;
import org.opentripplanner.service.vehicleparking.VehicleParkingService;
import org.opentripplanner.service.vehiclerental.VehicleRentalService;
import org.opentripplanner.service.worldenvelope.WorldEnvelopeService;
import org.opentripplanner.standalone.api.OtpServerRequestContext;
import org.opentripplanner.standalone.config.DebugUiConfig;
import org.opentripplanner.standalone.config.RouterConfig;
import org.opentripplanner.standalone.config.routerconfig.TransitRoutingConfig;
import org.opentripplanner.standalone.config.routerconfig.VectorTileConfig;
import org.opentripplanner.standalone.config.sandbox.TransmodelAPIConfig;
import org.opentripplanner.standalone.server.DefaultServerRequestContext;
import org.opentripplanner.street.service.StreetLimitationParametersService;
import org.opentripplanner.transit.service.TransitService;
import org.opentripplanner.visualizer.GraphVisualizer;

@Module
public class ConstructApplicationModule {
    @Provides
    OtpServerRequestContext providesServerContext(RouterConfig routerConfig, DebugUiConfig debugUiConfig, RaptorConfig<TripSchedule> raptorConfig, Graph graph, VertexLinker vertexLinker, TransitService transitService, WorldEnvelopeService worldEnvelopeService, RealtimeVehicleService realtimeVehicleService, VehicleRentalService vehicleRentalService, VehicleParkingService vehicleParkingService, List<RideHailingService> rideHailingServices, ViaCoordinateTransferFactory viaTransferResolver, @Nullable StopConsolidationService stopConsolidationService, StreetLimitationParametersService streetLimitationParametersService, @Nullable TraverseVisitor<?, ?> traverseVisitor, @Nullable @EmissionDecorator ItineraryDecorator emissionItineraryDecorator, @Nullable @GtfsSchema GraphQLSchema gtfsSchema, @Nullable @TransmodelSchema GraphQLSchema transmodelSchema, @Nullable SorlandsbanenNorwayService sorlandsbanenService, LauncherRequestDecorator launcherRequestDecorator, @Nullable LuceneIndex luceneIndex, FareService fareService) {
        RouteRequest defaultRequest = launcherRequestDecorator.intercept(routerConfig.routingRequestDefaults());
        TransitRoutingConfig transitRoutingConfig = routerConfig.transitTuningConfig();
        TriasApiParameters triasApiParameters = routerConfig.triasApiParameters();
        GtfsApiParameters gtfsApiConfig = routerConfig.gtfsApiParameters();
        VectorTileConfig vectorTileConfig = routerConfig.vectorTileConfig();
        FlexParameters flexParameters = routerConfig.flexParameters();
        TransmodelAPIConfig transmodelAPIParameters = routerConfig.transmodelApi();
        return new DefaultServerRequestContext(debugUiConfig, fareService, flexParameters, graph, (MeterRegistry)Metrics.globalRegistry, raptorConfig, realtimeVehicleService, rideHailingServices, defaultRequest, streetLimitationParametersService, transitRoutingConfig, transitService, triasApiParameters, gtfsApiConfig, vectorTileConfig, vehicleParkingService, vehicleRentalService, vertexLinker, viaTransferResolver, worldEnvelopeService, emissionItineraryDecorator, luceneIndex, gtfsSchema, transmodelSchema, sorlandsbanenService, stopConsolidationService, traverseVisitor, transmodelAPIParameters);
    }

    @Singleton
    @Provides
    public FareService fareService(FareServiceFactory fareServiceFactory) {
        return fareServiceFactory.makeFareService();
    }

    @Provides
    @Nullable
    TraverseVisitor<?, ?> traverseVisitor(@Nullable GraphVisualizer graphVisualizer) {
        return graphVisualizer == null ? null : graphVisualizer.traverseVisitor;
    }
}

