/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.configure;

import jakarta.ws.rs.core.Application;
import java.util.List;
import javax.annotation.Nullable;
import org.opentripplanner.datastore.api.DataSource;
import org.opentripplanner.ext.emission.EmissionRepository;
import org.opentripplanner.ext.stopconsolidation.StopConsolidationRepository;
import org.opentripplanner.framework.application.LogMDCSupport;
import org.opentripplanner.framework.application.OTPFeature;
import org.opentripplanner.framework.geometry.WgsCoordinate;
import org.opentripplanner.graph_builder.GraphBuilder;
import org.opentripplanner.graph_builder.GraphBuilderDataSources;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueSummary;
import org.opentripplanner.raptor.configure.RaptorConfig;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.RaptorTransitData;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TransitTuningParameters;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripSchedule;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers.RaptorTransitDataMapper;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.fares.FareServiceFactory;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.linking.VertexLinker;
import org.opentripplanner.service.osminfo.OsmInfoGraphBuildRepository;
import org.opentripplanner.service.realtimevehicles.RealtimeVehicleRepository;
import org.opentripplanner.service.vehicleparking.VehicleParkingRepository;
import org.opentripplanner.service.vehicleparking.VehicleParkingService;
import org.opentripplanner.service.vehiclerental.VehicleRentalRepository;
import org.opentripplanner.service.worldenvelope.WorldEnvelopeRepository;
import org.opentripplanner.standalone.api.OtpServerRequestContext;
import org.opentripplanner.standalone.config.BuildConfig;
import org.opentripplanner.standalone.config.CommandLineParameters;
import org.opentripplanner.standalone.config.ConfigModel;
import org.opentripplanner.standalone.config.DebugUiConfig;
import org.opentripplanner.standalone.config.OtpConfig;
import org.opentripplanner.standalone.config.RouterConfig;
import org.opentripplanner.standalone.configure.ConstructApplicationFactory;
import org.opentripplanner.standalone.configure.DaggerConstructApplicationFactory;
import org.opentripplanner.standalone.server.GrizzlyServer;
import org.opentripplanner.standalone.server.OTPWebApplication;
import org.opentripplanner.street.model.StreetLimitationParameters;
import org.opentripplanner.street.model.elevation.ElevationUtils;
import org.opentripplanner.transit.service.TimetableRepository;
import org.opentripplanner.updater.configure.UpdaterConfigurator;
import org.opentripplanner.updater.trip.TimetableSnapshotManager;
import org.opentripplanner.utils.logging.ProgressTracker;
import org.opentripplanner.visualizer.GraphVisualizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstructApplication {
    private static final Logger LOG = LoggerFactory.getLogger(ConstructApplication.class);
    private final CommandLineParameters cli;
    private final GraphBuilderDataSources graphBuilderDataSources;
    private final OsmInfoGraphBuildRepository osmInfoGraphBuildRepository;
    private final ConstructApplicationFactory factory;

    ConstructApplication(CommandLineParameters cli, Graph graph, OsmInfoGraphBuildRepository osmInfoGraphBuildRepository, TimetableRepository timetableRepository, WorldEnvelopeRepository worldEnvelopeRepository, ConfigModel config, GraphBuilderDataSources graphBuilderDataSources, DataImportIssueSummary issueSummary, EmissionRepository emissionRepository, VehicleParkingRepository vehicleParkingRepository, @Nullable StopConsolidationRepository stopConsolidationRepository, StreetLimitationParameters streetLimitationParameters, FareServiceFactory fareServiceFactory) {
        this.cli = cli;
        this.graphBuilderDataSources = graphBuilderDataSources;
        this.osmInfoGraphBuildRepository = osmInfoGraphBuildRepository;
        GraphVisualizer graphVisualizer = cli.visualize ? new GraphVisualizer(graph) : null;
        ConstructApplicationFactory.Builder builder = DaggerConstructApplicationFactory.builder();
        this.factory = builder.configModel(config).graph(graph).timetableRepository(timetableRepository).graphVisualizer(graphVisualizer).worldEnvelopeRepository(worldEnvelopeRepository).vehicleParkingRepository(vehicleParkingRepository).emissionRepository(emissionRepository).dataImportIssueSummary(issueSummary).stopConsolidationRepository(stopConsolidationRepository).streetLimitationParameters(streetLimitationParameters).schema(config.routerConfig().routingRequestDefaults()).fareServiceFactory(fareServiceFactory).build();
    }

    public ConstructApplicationFactory getFactory() {
        return this.factory;
    }

    public GrizzlyServer createGrizzlyServer() {
        return new GrizzlyServer(this.cli, this.createApplication(), this.routerConfig().server().apiProcessingTimeout());
    }

    public GraphBuilder createGraphBuilder() {
        LOG.info("Wiring up and configuring graph builder task.");
        return GraphBuilder.create(this.buildConfig(), this.graphBuilderDataSources, this.graph(), this.osmInfoGraphBuildRepository, this.fareServiceFactory(), this.factory.timetableRepository(), this.factory.worldEnvelopeRepository(), this.factory.vehicleParkingRepository(), this.factory.emissionRepository(), this.factory.stopConsolidationRepository(), this.factory.streetLimitationParameters(), this.cli.doLoadStreetGraph(), this.cli.doSaveStreetGraph());
    }

    @Nullable
    public DataSource graphOutputDataSource() {
        return this.graphBuilderDataSources.getOutputGraph();
    }

    public GraphBuilderDataSources graphBuilderDataSources() {
        return this.graphBuilderDataSources;
    }

    private Application createApplication() {
        LOG.info("Wiring up and configuring server.");
        this.setupTransitRoutingServer();
        return new OTPWebApplication(this.routerConfig().server(), this::createServerContext);
    }

    private void setupTransitRoutingServer() {
        this.enableRequestTraceLogging();
        this.createMetricsLogging();
        ConstructApplication.createRaptorTransitData(this.timetableRepository(), this.routerConfig().transitTuningConfig());
        UpdaterConfigurator.configure(this.graph(), this.vertexLinker(), this.realtimeVehicleRepository(), this.vehicleRentalRepository(), this.vehicleParkingRepository(), this.timetableRepository(), this.snapshotManager(), this.routerConfig().updaterConfig());
        this.initEllipsoidToGeoidDifference();
        ConstructApplication.initializeTransferCache(this.routerConfig().transitTuningConfig(), this.timetableRepository());
        if (OTPFeature.SandboxAPIGeocoder.isOn()) {
            LOG.info("Initializing geocoder");
            this.factory.luceneIndex();
        }
    }

    private void initEllipsoidToGeoidDifference() {
        try {
            WgsCoordinate c = this.factory.worldEnvelopeService().envelope().orElseThrow().center();
            double value = ElevationUtils.computeEllipsoidToGeoidDifference(c.latitude(), c.longitude());
            this.graph().initEllipsoidToGeoidDifference(value, c.latitude(), c.longitude());
        }
        catch (Exception e) {
            LOG.error("Error computing ellipsoid/geoid difference");
        }
    }

    public static void createRaptorTransitData(TimetableRepository timetableRepository, TransitTuningParameters tuningParameters) {
        if (!timetableRepository.hasTransit() || !timetableRepository.isIndexed()) {
            LOG.warn("Cannot create Raptor data, that requires the graph to have transit data and be indexed.");
        }
        LOG.info("Creating transit layer for Raptor routing.");
        timetableRepository.setRaptorTransitData(RaptorTransitDataMapper.map(tuningParameters, timetableRepository));
        timetableRepository.setRealtimeRaptorTransitData(new RaptorTransitData(timetableRepository.getRaptorTransitData()));
    }

    public static void initializeTransferCache(TransitTuningParameters transitTuningConfig, TimetableRepository timetableRepository) {
        List<RouteRequest> transferCacheRequests = transitTuningConfig.transferCacheRequests();
        if (!transferCacheRequests.isEmpty()) {
            ProgressTracker progress = ProgressTracker.track((String)"Creating initial raptor transfer cache", (int)1, (long)transferCacheRequests.size());
            LOG.info(progress.startMessage());
            transferCacheRequests.forEach(request -> {
                timetableRepository.getRaptorTransitData().initTransferCacheForRequest((RouteRequest)request);
                progress.step(s -> LOG.info(s));
            });
            LOG.info(progress.completeMessage());
        }
    }

    public TimetableRepository timetableRepository() {
        return this.factory.timetableRepository();
    }

    public DataImportIssueSummary dataImportIssueSummary() {
        return this.factory.dataImportIssueSummary();
    }

    public OsmInfoGraphBuildRepository osmInfoGraphBuildRepository() {
        return this.osmInfoGraphBuildRepository;
    }

    public StopConsolidationRepository stopConsolidationRepository() {
        return this.factory.stopConsolidationRepository();
    }

    public RealtimeVehicleRepository realtimeVehicleRepository() {
        return this.factory.realtimeVehicleRepository();
    }

    public VehicleRentalRepository vehicleRentalRepository() {
        return this.factory.vehicleRentalRepository();
    }

    private TimetableSnapshotManager snapshotManager() {
        return this.factory.timetableSnapshotManager();
    }

    public VehicleParkingService vehicleParkingService() {
        return this.factory.vehicleParkingService();
    }

    public VehicleParkingRepository vehicleParkingRepository() {
        return this.factory.vehicleParkingRepository();
    }

    public Graph graph() {
        return this.factory.graph();
    }

    public VertexLinker vertexLinker() {
        return this.factory.vertexLinker();
    }

    public WorldEnvelopeRepository worldEnvelopeRepository() {
        return this.factory.worldEnvelopeRepository();
    }

    public OtpConfig otpConfig() {
        return this.factory.config().otpConfig();
    }

    public RouterConfig routerConfig() {
        return this.factory.config().routerConfig();
    }

    public BuildConfig buildConfig() {
        return this.factory.config().buildConfig();
    }

    public DebugUiConfig debugUiConfig() {
        return this.factory.config().debugUiConfig();
    }

    public RaptorConfig<TripSchedule> raptorConfig() {
        return this.factory.raptorConfig();
    }

    public GraphVisualizer graphVisualizer() {
        return this.factory.graphVisualizer();
    }

    private OtpServerRequestContext createServerContext() {
        return this.factory.createServerContext();
    }

    private void enableRequestTraceLogging() {
        if (this.routerConfig().server().requestTraceLoggingEnabled()) {
            LogMDCSupport.enable();
        }
    }

    private void createMetricsLogging() {
        this.factory.metricsLogging();
    }

    public EmissionRepository emissionRepository() {
        return this.factory.emissionRepository();
    }

    public StreetLimitationParameters streetLimitationParameters() {
        return this.factory.streetLimitationParameters();
    }

    public FareServiceFactory fareServiceFactory() {
        return this.factory.fareServiceFactory();
    }
}

