/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.config.sandbox;

import java.util.List;
import org.opentripplanner.ext.vehiclerentalservicedirectory.api.NetworkParameters;
import org.opentripplanner.ext.vehiclerentalservicedirectory.api.VehicleRentalServiceDirectoryFetcherParameters;
import org.opentripplanner.standalone.config.framework.json.NodeAdapter;
import org.opentripplanner.standalone.config.framework.json.OtpVersion;
import org.opentripplanner.standalone.config.routerconfig.updaters.HttpHeadersConfig;

public class VehicleRentalServiceDirectoryFetcherConfig {
    public static VehicleRentalServiceDirectoryFetcherParameters create(String parameterName, NodeAdapter root) {
        NodeAdapter c = root.of(parameterName).since(OtpVersion.V2_0).summary("Configuration for the vehicle rental service directory.").asObject();
        if (c.isEmpty()) {
            return null;
        }
        return new VehicleRentalServiceDirectoryFetcherParameters(c.of("url").since(OtpVersion.V2_1).summary("Endpoint for the VehicleRentalServiceDirectory").asUri(), c.of("sourcesName").since(OtpVersion.V2_1).summary("Json tag name for updater sources.").asString("systems"), c.of("updaterUrlName").since(OtpVersion.V2_1).summary("Json tag name for endpoint urls for each source.").asString("url"), c.of("updaterNetworkName").since(OtpVersion.V2_1).summary("Json tag name for the network name for each source.").asString("id"), c.of("language").since(OtpVersion.V2_1).summary("Language code.").asString(null), HttpHeadersConfig.headers(c, OtpVersion.V2_1), VehicleRentalServiceDirectoryFetcherConfig.mapNetworkParameters("networks", c));
    }

    private static List<NetworkParameters> mapNetworkParameters(String parameterName, NodeAdapter root) {
        return root.of(parameterName).since(OtpVersion.V2_4).summary("List all networks to include. Use \"network\": \"default-network\" to set defaults.").description("If no default network exists only the listed networks are used. Configure a network with\nname \"{{default-network}}\" to include all unlisted networks. If not present, all unlisted\nnetworks are dropped. Note! The values in the \"{{default-network}}\" are not used to set\nmissing field values in networks listed.\n".replace("{{default-network}}", "default-network")).asObjects(c -> new NetworkParameters(c.of("network").since(OtpVersion.V2_4).summary("The network name").asString(), c.of("geofencingZones").since(OtpVersion.V2_4).summary("Enables geofencingZones for the given network").description("See the regular [GBFS documentation](../GBFS-Config.md) for more information.").asBoolean(false), c.of("allowKeepingVehicleAtDestination").since(OtpVersion.V2_5).summary("Enables `allowKeepingVehicleAtDestination` for the given network.").description("Configures if a vehicle rented from a station must be returned to another one or can\nbe kept at the end of the trip.\n\nSee the regular [GBFS documentation](../GBFS-Config.md) for more information.\n").asBoolean(false)));
    }
}

