/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.config.sandbox;

import java.util.Collection;
import java.util.Set;
import org.opentripplanner.apis.transmodel.TransmodelAPIParameters;
import org.opentripplanner.standalone.config.framework.json.NodeAdapter;
import org.opentripplanner.standalone.config.framework.json.OtpVersion;

public class TransmodelAPIConfig
implements TransmodelAPIParameters {
    private final boolean hideFeedId;
    private final Collection<String> tracingHeaderTags;
    private final int maxNumberOfResultFields;

    public TransmodelAPIConfig(String parameterName, NodeAdapter root) {
        NodeAdapter c = root.of(parameterName).since(OtpVersion.V2_1).summary("Configuration for the Transmodel GraphQL API.").asObject();
        this.hideFeedId = c.of("hideFeedId").summary("Hide the FeedId in all API output, and add it to input.").description("Only turn this feature on if you have unique ids across all feeds, without the feedId prefix.").asBoolean(false);
        this.tracingHeaderTags = c.of("tracingHeaderTags").summary("Used to group requests when monitoring OTP.").asStringList(Set.of());
        this.maxNumberOfResultFields = c.of("maxNumberOfResultFields").since(OtpVersion.V2_6).summary("The maximum number of fields in a GraphQL result").description("Enforce rate limiting based on query complexity; Queries that return too much data are cancelled.").asInt(1000000);
    }

    @Override
    public boolean hideFeedId() {
        return this.hideFeedId;
    }

    @Override
    public Collection<String> tracingHeaderTags() {
        return this.tracingHeaderTags;
    }

    @Override
    public int maxNumberOfResultFields() {
        return this.maxNumberOfResultFields;
    }
}

