/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.config.routerconfig.updaters.azure;

import java.time.Duration;
import java.time.LocalDate;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import org.opentripplanner.ext.siri.updater.azure.AuthenticationType;
import org.opentripplanner.ext.siri.updater.azure.SiriAzureUpdaterParameters;
import org.opentripplanner.standalone.config.framework.json.NodeAdapter;
import org.opentripplanner.standalone.config.framework.json.OtpVersion;

public abstract class SiriAzureUpdaterConfig {
    public static void populateConfig(SiriAzureUpdaterParameters parameters, String configRef, NodeAdapter c) {
        parameters.setConfigRef(configRef);
        parameters.setServiceBusUrl(c.of("servicebus-url").since(OtpVersion.V2_2).summary("Service Bus connection used for authentication.").description("Has to be present for authenticationMethod SharedAccessKey. This should be Primary/Secondary connection string from service bus.").asString(null));
        parameters.setTopicName(c.of("topic").since(OtpVersion.V2_2).summary("Service Bus topic to connect to.").asString());
        parameters.setFeedId(c.of("feedId").since(OtpVersion.V2_2).summary("The ID of the feed to apply the updates to.").asString());
        parameters.setAutoDeleteOnIdle(c.of("autoDeleteOnIdle").since(OtpVersion.V2_5).summary("The time after which an inactive subscription is removed.").asDuration(Duration.ofHours(1L)));
        parameters.setPrefetchCount(c.of("prefetchCount").since(OtpVersion.V2_5).summary("The number of messages to fetch from the subscription at a time.").asInt(10));
        parameters.setFuzzyTripMatching(c.of("fuzzyTripMatching").since(OtpVersion.V2_2).summary("Whether to apply fuzzyTripMatching on the updates").asBoolean(false));
        parameters.setFullyQualifiedNamespace(c.of("fullyQualifiedNamespace").since(OtpVersion.V2_5).summary("Service Bus fully qualified namespace used for authentication.").description("Has to be present for authenticationMethod FederatedIdentity.").asString(null));
        parameters.setAuthenticationType(c.of("authenticationType").since(OtpVersion.V2_5).summary("Which authentication type to use").asEnum(AuthenticationType.SharedAccessKey));
        if (c.exist("history")) {
            NodeAdapter history = c.of("history").since(OtpVersion.V2_2).summary("Configuration for fetching historical data on startup").asObject();
            parameters.setDataInitializationUrl(history.of("url").since(OtpVersion.NA).summary("Endpoint to fetch from").asString(null));
            parameters.setTimeout(history.of("timeout").since(OtpVersion.NA).summary("Timeout in milliseconds").asInt(300000));
        }
        parameters.setStartupTimeout(c.of("startupTimeout").summary("Maximum time to wait for real-time services during startup.").description("Maximum time to wait for real-time services during startup. If real-time services are unavailable, OTP will start without real-time data after this timeout.").asDuration(parameters.getStartupTimeout()));
    }

    protected static LocalDate asDateOrRelativePeriod(String text, int customMidnight) {
        try {
            if (text == null || text.isBlank()) {
                return null;
            }
            if (text.startsWith("-") || text.startsWith("P")) {
                return SiriAzureUpdaterConfig.getDateBasedOnCustomMidnight(ZonedDateTime.now(ZoneId.of("CET")).plus(Period.parse(text)), customMidnight);
            }
            return LocalDate.parse(text);
        }
        catch (DateTimeParseException e) {
            throw new IllegalArgumentException(text + "' is not a Period or LocalDate. Details: " + e.getLocalizedMessage());
        }
    }

    public static LocalDate getDateBasedOnCustomMidnight(ZonedDateTime time, int customMidnight) {
        if (time.isBefore(time.withHour(customMidnight).withMinute(0).withSecond(0).withNano(0))) {
            return time.minusDays(1L).toLocalDate();
        }
        return time.toLocalDate();
    }
}

