/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.config.routerconfig.updaters.azure;

import org.opentripplanner.ext.siri.updater.azure.SiriAzureSXUpdaterParameters;
import org.opentripplanner.standalone.config.framework.json.NodeAdapter;
import org.opentripplanner.standalone.config.framework.json.OtpVersion;
import org.opentripplanner.standalone.config.routerconfig.updaters.azure.SiriAzureUpdaterConfig;

public class SiriAzureSXUpdaterConfig
extends SiriAzureUpdaterConfig {
    public static SiriAzureSXUpdaterParameters create(String configRef, NodeAdapter c) {
        SiriAzureSXUpdaterParameters parameters = new SiriAzureSXUpdaterParameters();
        SiriAzureSXUpdaterConfig.populateConfig(parameters, configRef, c);
        if (c.exist("history")) {
            NodeAdapter history = c.of("history").since(OtpVersion.V2_2).summary("Configuration for fetching historical data on startup.").asObject();
            String fromDateTime = history.of("fromDateTime").since(OtpVersion.V2_2).summary("Datetime boundary for historical data.").asString("-P1D");
            String toDateTime = history.of("toDateTime").since(OtpVersion.V2_2).summary("Datetime boundary for historical data.").asString("P1D");
            int customMidnight = c.of("customMidnight").since(OtpVersion.V2_2).summary("Time on which time breaks into new day.").description("It is common that operating day date breaks a little bit later than midnight so that the switch happens when traffic is at the lowest point. Parameter uses 24-hour format. If the switch happens on 4 am then set this field to 4.").asInt(0);
            parameters.setFromDateTime(SiriAzureSXUpdaterConfig.asDateOrRelativePeriod(fromDateTime, customMidnight));
            parameters.setToDateTime(SiriAzureSXUpdaterConfig.asDateOrRelativePeriod(toDateTime, customMidnight));
        }
        return parameters;
    }
}

