/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.config.routerconfig.updaters;

import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.Set;
import org.opentripplanner.standalone.config.framework.json.NodeAdapter;
import org.opentripplanner.standalone.config.framework.json.OtpVersion;
import org.opentripplanner.standalone.config.routerconfig.updaters.HttpHeadersConfig;
import org.opentripplanner.updater.spi.HttpHeaders;
import org.opentripplanner.updater.vehicle_position.VehiclePositionsUpdaterParameters;

public class VehiclePositionsUpdaterConfig {
    public static VehiclePositionsUpdaterParameters create(String updaterRef, NodeAdapter c) {
        String feedId = c.of("feedId").since(OtpVersion.V2_2).summary("Feed ID to which the update should be applied.").asString();
        Duration frequency = c.of("frequency").since(OtpVersion.V2_2).summary("How often the positions should be updated.").asDuration(Duration.ofMinutes(1L));
        URI url = c.of("url").since(OtpVersion.V2_2).summary("The URL of GTFS-RT protobuf HTTP resource to download the positions from.").asUri();
        Boolean fuzzyTripMatching = c.of("fuzzyTripMatching").since(OtpVersion.V2_5).summary("Whether to match trips fuzzily.").asBoolean(false);
        Set<VehiclePositionFeature> features = c.of("features").since(OtpVersion.V2_5).summary("Which features of GTFS RT vehicle positions should be loaded into OTP.").asEnumSet(VehiclePositionFeature.class, List.of(VehiclePositionFeature.POSITION, VehiclePositionFeature.STOP_POSITION, VehiclePositionFeature.OCCUPANCY));
        HttpHeaders headers = HttpHeadersConfig.headers(c, OtpVersion.V2_3);
        return new VehiclePositionsUpdaterParameters(updaterRef, feedId, url, frequency, headers, fuzzyTripMatching, features);
    }

    public static enum VehiclePositionFeature {
        POSITION,
        STOP_POSITION,
        OCCUPANCY;

    }
}

