/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.config.routerconfig.updaters;

import java.time.Duration;
import org.opentripplanner.standalone.config.framework.json.NodeAdapter;
import org.opentripplanner.standalone.config.framework.json.OtpVersion;
import org.opentripplanner.standalone.config.routerconfig.updaters.HttpHeadersConfig;
import org.opentripplanner.updater.trip.siri.updater.SiriETUpdaterParameters;

public class SiriETUpdaterConfig {
    public static SiriETUpdaterParameters create(String configRef, NodeAdapter c) {
        return new SiriETUpdaterParameters(configRef, c.of("feedId").since(OtpVersion.V2_0).summary("The ID of the feed to apply the updates to.").asString(), c.of("blockReadinessUntilInitialized").since(OtpVersion.V2_0).summary("Whether catching up with the updates should block the readiness check from returning a 'ready' result.").asBoolean(false), c.of("url").since(OtpVersion.V2_0).summary("The URL to send the HTTP requests to.").description("Use the file protocol to set a directory for reading updates from a directory. The file\nloader will look for xml files: '*.xml' in the configured directory. The files are\nrenamed by the loader when processed:\n\n&nbsp;&nbsp;&nbsp; _a.xml_ &nbsp; \u279e &nbsp; _a.xml.inProgress_ &nbsp; \u279e &nbsp; _a.xml.ok_ &nbsp; or &nbsp; _a.xml.failed_\n\n").asString(), c.of("frequency").since(OtpVersion.V2_0).summary("How often the updates should be retrieved.").asDuration(Duration.ofMinutes(1L)), c.of("requestorRef").since(OtpVersion.V2_0).summary("The requester reference.").asString(null), c.of("timeout").since(OtpVersion.V2_0).summary("The HTTP timeout to download the updates.").asDuration(Duration.ofSeconds(15L)), c.of("previewInterval").since(OtpVersion.V2_0).summary("TODO").asDuration(null), c.of("fuzzyTripMatching").since(OtpVersion.V2_0).summary("If the fuzzy trip matcher should be used to match trips.").asBoolean(false), HttpHeadersConfig.headers(c, OtpVersion.V2_3), c.of("producerMetrics").since(OtpVersion.V2_7).summary("If failure, success, and warning metrics should be collected per producer.").asBoolean(false));
    }
}

