/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.config.routerconfig.updaters;

import java.time.Duration;
import org.opentripplanner.framework.doc.DocumentedEnum;
import org.opentripplanner.standalone.config.framework.json.EnumMapper;
import org.opentripplanner.standalone.config.framework.json.NodeAdapter;
import org.opentripplanner.standalone.config.framework.json.OtpVersion;
import org.opentripplanner.standalone.config.routerconfig.updaters.HttpHeadersConfig;
import org.opentripplanner.updater.spi.HttpHeaders;
import org.opentripplanner.updater.trip.gtfs.BackwardsDelayPropagationType;
import org.opentripplanner.updater.trip.gtfs.ForwardsDelayPropagationType;
import org.opentripplanner.updater.trip.gtfs.updater.http.PollingTripUpdaterParameters;

public class PollingTripUpdaterConfig {
    public static PollingTripUpdaterParameters create(String configRef, NodeAdapter c) {
        String url = c.of("url").since(OtpVersion.V1_5).summary("The URL of the GTFS-RT resource.").description("`file:` URLs are also supported if you want to read a file from the local disk.").asString();
        HttpHeaders headers = HttpHeadersConfig.headers(c, OtpVersion.V2_3);
        return new PollingTripUpdaterParameters(configRef, c.of("frequency").since(OtpVersion.V1_5).summary("How often the data should be downloaded.").asDuration(Duration.ofMinutes(1L)), c.of("fuzzyTripMatching").since(OtpVersion.V1_5).summary("If the trips should be matched fuzzily.").asBoolean(false), c.of("forwardsDelayPropagationType").since(OtpVersion.V2_8).summary(ForwardsDelayPropagationType.DEFAULT.typeDescription()).description(EnumMapper.docEnumValueList((DocumentedEnum[])ForwardsDelayPropagationType.values())).asEnum(ForwardsDelayPropagationType.DEFAULT), c.of("backwardsDelayPropagationType").since(OtpVersion.V2_2).summary(BackwardsDelayPropagationType.REQUIRED_NO_DATA.typeDescription()).description(EnumMapper.docEnumValueList((DocumentedEnum[])BackwardsDelayPropagationType.values())).asEnum(BackwardsDelayPropagationType.REQUIRED_NO_DATA), c.of("feedId").since(OtpVersion.V1_5).summary("Which feed the updates apply to.").asString(), url, headers);
    }
}

