/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.config.routerconfig;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.opentripplanner.ext.vectortiles.VectorTilesResource;
import org.opentripplanner.ext.vectortiles.layers.LayerFilters;
import org.opentripplanner.inspector.vector.LayerParameters;
import org.opentripplanner.standalone.config.framework.json.NodeAdapter;
import org.opentripplanner.standalone.config.framework.json.OtpVersion;

public class VectorTileConfig
implements VectorTilesResource.LayersParameters<VectorTilesResource.LayerType> {
    public static final VectorTileConfig DEFAULT = new VectorTileConfig(List.of(), null, null);
    private final List<LayerParameters<VectorTilesResource.LayerType>> layers;
    @Nullable
    private final String basePath;
    @Nullable
    private final String attribution;

    VectorTileConfig(Collection<? extends LayerParameters<VectorTilesResource.LayerType>> layers, @Nullable String basePath, @Nullable String attribution) {
        this.layers = List.copyOf(layers);
        this.basePath = basePath;
        this.attribution = attribution;
    }

    @Override
    public List<LayerParameters<VectorTilesResource.LayerType>> layers() {
        return this.layers;
    }

    public Optional<String> basePath() {
        return Optional.ofNullable(this.basePath);
    }

    public Optional<String> attribution() {
        return Optional.ofNullable(this.attribution);
    }

    public static VectorTileConfig mapVectorTilesParameters(NodeAdapter node, String paramName) {
        NodeAdapter root = node.of(paramName).summary("Vector tile configuration").asObject();
        return new VectorTileConfig(root.of("layers").since(OtpVersion.V2_0).summary("Configuration of the individual layers for the Mapbox vector tiles.").asObjects(VectorTileConfig::mapLayer), root.of("basePath").since(OtpVersion.V2_5).summary("The path of the vector tile source URLs in `tilejson.json`.").description("This is useful if you have a proxy setup and rewrite the path that is passed to OTP.\n\nIf you don't configure this optional value then the path returned in `tilejson.json` is in\nthe format `/otp/routers/default/vectorTiles/layer1,layer2/{z}/{x}/{x}.pbf`.\nIf you, for example, set a value of `/otp_test/tiles` then the returned path changes to\n`/otp_test/tiles/layer1,layer2/{z}/{x}/{x}.pbf`.\n\nThe protocol and host are always read from the incoming HTTP request. If you run OTP behind\na proxy then make sure to set the headers `X-Forwarded-Proto` and `X-Forwarded-Host` to make OTP\nreturn the protocol and host for the original request and not the proxied one.\n\n**Note:** This does _not_ change the path that OTP itself serves the tiles or `tilejson.json`\nresponses but simply changes the URLs listed in `tilejson.json`. The rewriting of the path\nis expected to be handled by a proxy.\n").asString(VectorTileConfig.DEFAULT.basePath), root.of("attribution").since(OtpVersion.V2_5).summary("Custom attribution to be returned in `tilejson.json`").description("By default the, `attribution` property in `tilejson.json` is computed from the names and\nURLs of the feed publishers.\nIf the OTP deployment contains many feeds, this can become very unwieldy.\n\nThis configuration parameter allows you to set the `attribution` to any string you wish\nincluding HTML tags,\nfor example `<a href='https://trimet.org/mod'>Regional Partners</a>`.\n").asString(VectorTileConfig.DEFAULT.attribution));
    }

    public static Layer mapLayer(NodeAdapter node) {
        return new Layer(node.of("name").since(OtpVersion.V2_0).summary("Used in the url to fetch tiles, and as the layer name in the vector tiles.").asString(), (VectorTilesResource.LayerType)((Object)node.of("type").since(OtpVersion.V2_0).summary("Type of the layer.").asEnum(VectorTilesResource.LayerType.class)), node.of("mapper").since(OtpVersion.V2_0).summary("Describes the mapper converting from the OTP model entities to the vector tile properties.").description("Currently `Digitransit` is supported for all layer types.").asString(), node.of("maxZoom").since(OtpVersion.V2_0).summary("Maximum zoom levels the layer is active for.").asInt(20), node.of("minZoom").since(OtpVersion.V2_0).summary("Minimum zoom levels the layer is active for.").asInt(9), node.of("cacheMaxSeconds").since(OtpVersion.V2_0).summary("Sets the cache header in the response.").description("The lowest value of the layers included is selected.").asInt(-1), node.of("expansionFactor").since(OtpVersion.V2_0).summary("How far outside its boundaries should the tile contain information.").description("The value is a fraction of the tile size. If you are having problem with icons and shapes being clipped at tile edges, then increase this number.").asDouble(0.25), node.of("filter").since(OtpVersion.V2_6).summary("Reduce the result set of a layer further by a specific filter.").description("This is useful for when the schema of a layer, say stops, should remain unchanged but some\nelements should not be included in the result.\n").asEnum(LayerFilters.FilterType.NONE));
    }

    public int minZoom(Set<String> requestedLayers) {
        return this.selectLayers(requestedLayers).mapToInt(LayerParameters::minZoom).min().orElse(9);
    }

    public int maxZoom(Set<String> requestedLayers) {
        return this.selectLayers(requestedLayers).mapToInt(LayerParameters::maxZoom).max().orElse(20);
    }

    private Stream<LayerParameters<VectorTilesResource.LayerType>> selectLayers(Set<String> requestedLayers) {
        return this.layers.stream().filter(l -> requestedLayers.contains(l.name()));
    }

    static final class Layer
    extends Record
    implements LayerParameters<VectorTilesResource.LayerType> {
        private final String name;
        private final VectorTilesResource.LayerType type;
        private final String mapper;
        private final int maxZoom;
        private final int minZoom;
        private final int cacheMaxSeconds;
        private final double expansionFactor;
        private final LayerFilters.FilterType filterType;

        Layer(String name, VectorTilesResource.LayerType type, String mapper, int maxZoom, int minZoom, int cacheMaxSeconds, double expansionFactor, LayerFilters.FilterType filterType) {
            this.name = name;
            this.type = type;
            this.mapper = mapper;
            this.maxZoom = maxZoom;
            this.minZoom = minZoom;
            this.cacheMaxSeconds = cacheMaxSeconds;
            this.expansionFactor = expansionFactor;
            this.filterType = filterType;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Layer.class, "name;type;mapper;maxZoom;minZoom;cacheMaxSeconds;expansionFactor;filterType", "name", "type", "mapper", "maxZoom", "minZoom", "cacheMaxSeconds", "expansionFactor", "filterType"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Layer.class, "name;type;mapper;maxZoom;minZoom;cacheMaxSeconds;expansionFactor;filterType", "name", "type", "mapper", "maxZoom", "minZoom", "cacheMaxSeconds", "expansionFactor", "filterType"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Layer.class, "name;type;mapper;maxZoom;minZoom;cacheMaxSeconds;expansionFactor;filterType", "name", "type", "mapper", "maxZoom", "minZoom", "cacheMaxSeconds", "expansionFactor", "filterType"}, this, o);
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public VectorTilesResource.LayerType type() {
            return this.type;
        }

        @Override
        public String mapper() {
            return this.mapper;
        }

        @Override
        public int maxZoom() {
            return this.maxZoom;
        }

        @Override
        public int minZoom() {
            return this.minZoom;
        }

        @Override
        public int cacheMaxSeconds() {
            return this.cacheMaxSeconds;
        }

        @Override
        public double expansionFactor() {
            return this.expansionFactor;
        }

        @Override
        public LayerFilters.FilterType filterType() {
            return this.filterType;
        }
    }
}

