/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.config.routerconfig;

import java.time.Duration;
import java.util.List;
import org.opentripplanner.apis.support.graphql.injectdoc.ApiDocumentationProfile;
import org.opentripplanner.framework.application.OtpAppException;
import org.opentripplanner.framework.doc.DocumentedEnum;
import org.opentripplanner.standalone.config.framework.json.EnumMapper;
import org.opentripplanner.standalone.config.framework.json.NodeAdapter;
import org.opentripplanner.standalone.config.framework.json.OtpVersion;
import org.opentripplanner.standalone.server.OTPWebApplicationParameters;
import org.opentripplanner.standalone.server.RequestTraceParameter;

public class ServerConfig
implements OTPWebApplicationParameters {
    private final Duration apiProcessingTimeout;
    private final List<RequestTraceParameter> traceParameters;
    private final ApiDocumentationProfile apiDocumentationProfile;

    public ServerConfig(String parameterName, NodeAdapter root) {
        NodeAdapter c = root.of(parameterName).since(OtpVersion.V2_4).summary("Configuration for router server.").description("These parameters are used to configure the router server. Many parameters are specific to a\ndomain, these are set in the routing request.\n").asObject();
        this.apiProcessingTimeout = c.of("apiProcessingTimeout").since(OtpVersion.V2_4).summary("Maximum processing time for an API request").description("This timeout limits the server-side processing time for a given API request. This does not include\nnetwork latency nor waiting time in the HTTP server thread pool. The default value is\n`-1s`(no timeout). The timeout is applied to all APIs (Transmodel & GTFS GraphQL).\nThe timeout is not enforced when the parallel routing OTP feature is in use.\n").asDuration(Duration.ofSeconds(-1L));
        this.apiDocumentationProfile = c.of("apiDocumentationProfile").since(OtpVersion.V2_7).summary(ApiDocumentationProfile.DEFAULT.typeDescription()).description(EnumMapper.docEnumValueList((DocumentedEnum[])ApiDocumentationProfile.values())).asEnum(ApiDocumentationProfile.DEFAULT);
        this.traceParameters = c.of("traceParameters").since(OtpVersion.V2_4).summary("Trace OTP request using HTTP request/response parameter(s) combined with logging.").description("OTP supports tracing user requests across log events and \"outside\" services. OTP can insert\nhttp-request-header parameters into all associated log events and into the http response. If the\nvalue is not present in the request, a unique value can be generated. The OTP generated value is\na 6 characters long base 36[0-9a-z] character string.\n\n**Use-case Correlation-ID**\n\nA common use-case in a service oriented environment is to use a _correlation-id_ to identify all log\nmessages across multiple (micro-)services from the same user. This is done by setting the\n\"X-Correlation-ID\" http header in the http facade/gateway. Use the \"traceParameters\" to configure\nOTP to pick up the correlation id, insert it into the logs and return it. See the example below\non how-to configure the \"server.traceParameters\" instance.\n").asObjects(t -> new RequestTraceParameter(t.of("httpRequestHeader").since(OtpVersion.V2_4).summary("The header-key to use when fetching the trace parameter value").asString(null), t.of("httpResponseHeader").since(OtpVersion.V2_4).summary("The header-key to use when saving the value back into the http response").asString(null), t.of("logKey").since(OtpVersion.V2_4).summary("The log event key used.").description("OTP stores the key/value pair in the log MDC (Mapped Diagnostic Context). To use it\nyou normally include the key in the log pattern like this: `%X{LOG-KEY}`. See your\nlog framework for details. Only log4j and logback support this.\n").asString(null), t.of("generateIdIfMissing").since(OtpVersion.V2_4).summary("If `true` a unique value is generated if no http request header is provided, or the value is missing.").asBoolean(false)));
    }

    public Duration apiProcessingTimeout() {
        return this.apiProcessingTimeout;
    }

    @Override
    public List<RequestTraceParameter> traceParameters() {
        return this.traceParameters;
    }

    public ApiDocumentationProfile apiDocumentationProfile() {
        return this.apiDocumentationProfile;
    }

    public void validate(Duration streetRoutingTimeout) {
        if (!this.apiProcessingTimeout.isNegative() && streetRoutingTimeout.toSeconds() > this.apiProcessingTimeout.toSeconds()) {
            throw new OtpAppException("streetRoutingTimeout (" + String.valueOf(streetRoutingTimeout) + ") must be shorter than apiProcessingTimeout (" + String.valueOf(this.apiProcessingTimeout) + ")");
        }
    }
}

