/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.config.routerconfig;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nullable;
import org.opentripplanner.framework.application.OTPRequestTimeoutException;
import org.opentripplanner.framework.concurrent.OtpRequestThreadFactory;
import org.opentripplanner.raptor.api.request.RaptorEnvironment;

public class RaptorEnvironmentFactory {
    public static RaptorEnvironment create(final int threadPoolSize) {
        return new RaptorEnvironment(){

            public Runnable timeoutHook() {
                return OTPRequestTimeoutException::checkForTimeout;
            }

            public RuntimeException mapInterruptedException(InterruptedException e) {
                return new OTPRequestTimeoutException();
            }

            @Nullable
            public ExecutorService threadPool() {
                return threadPoolSize > 0 ? Executors.newFixedThreadPool(threadPoolSize, OtpRequestThreadFactory.of("raptor-%d")) : null;
            }
        };
    }
}

