/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.config.framework.project;

import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.opentripplanner.framework.application.OtpAppException;
import org.opentripplanner.model.projectinfo.OtpProjectInfo;
import org.opentripplanner.utils.text.TextVariablesSubstitution;

public class EnvironmentVariableReplacer {
    private static final Pattern PATTERN = Pattern.compile("\\$\\{([.\\w]+)}");
    private static final Map<String, String> PROJECT_INFO = Map.ofEntries(Map.entry("maven.version", OtpProjectInfo.projectInfo().version.version), Map.entry("maven.version.short", OtpProjectInfo.projectInfo().version.unqualifiedVersion()), Map.entry("maven.version.major", Integer.toString(OtpProjectInfo.projectInfo().version.major)), Map.entry("maven.version.minor", Integer.toString(OtpProjectInfo.projectInfo().version.minor)), Map.entry("maven.version.patch", Integer.toString(OtpProjectInfo.projectInfo().version.patch)), Map.entry("maven.version.qualifier", OtpProjectInfo.projectInfo().version.qualifier), Map.entry("graph.file.header", OtpProjectInfo.projectInfo().graphFileHeaderInfo.asString()), Map.entry("otp.serialization.version.id", OtpProjectInfo.projectInfo().graphFileHeaderInfo.otpSerializationVersionId()), Map.entry("git.branch", OtpProjectInfo.projectInfo().versionControl.branch), Map.entry("git.commit", OtpProjectInfo.projectInfo().versionControl.commit), Map.entry("git.commit.timestamp", OtpProjectInfo.projectInfo().versionControl.commitTime));

    public static String insertEnvironmentVariables(String text, String source) {
        return EnvironmentVariableReplacer.insertVariables(text, source, EnvironmentVariableReplacer::getEnvVarOrProjectInfo);
    }

    public static String insertVariables(String text, String source, Function<String, String> variableResolver) {
        return TextVariablesSubstitution.insertVariables((String)text, variableResolver, (T varName) -> EnvironmentVariableReplacer.errorVariableNameNotFound(varName, source));
    }

    @Nullable
    private static String getEnvVarOrProjectInfo(String key) {
        String value = System.getenv(key);
        if (value == null) {
            return PROJECT_INFO.get(key);
        }
        return value;
    }

    private static void errorVariableNameNotFound(String variableName, String source) {
        throw new OtpAppException("Environment variable name '" + variableName + "' in config '" + source + "' not found in the system environment variables.");
    }
}

