/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.config.framework.json;

import com.fasterxml.jackson.databind.JsonNode;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.opentripplanner.framework.application.OtpAppException;
import org.opentripplanner.framework.model.Gram;
import org.opentripplanner.routing.api.request.framework.CostLinearFunction;
import org.opentripplanner.routing.api.request.framework.TimePenalty;
import org.opentripplanner.standalone.config.framework.json.ConfigType;
import org.opentripplanner.standalone.config.framework.json.EnumMapper;
import org.opentripplanner.standalone.config.framework.json.NodeAdapter;
import org.opentripplanner.standalone.config.framework.json.NodeInfo;
import org.opentripplanner.standalone.config.framework.json.NodeInfoBuilder;
import org.opentripplanner.standalone.config.framework.json.OtpVersion;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.utils.time.DurationUtils;
import org.opentripplanner.utils.time.LocalDateUtils;

public class ParameterBuilder {
    private static final Object UNDEFINED = new Object();
    private final NodeInfoBuilder info = NodeInfo.of();
    private final NodeAdapter target;
    private Object docDefaultValue = UNDEFINED;

    public ParameterBuilder(NodeAdapter target, String paramName) {
        this.target = target;
        this.info.withName(paramName);
    }

    public ParameterBuilder since(OtpVersion version) {
        this.info.withSince(version);
        return this;
    }

    public ParameterBuilder summary(String summary) {
        this.info.withSummary(summary);
        return this;
    }

    public ParameterBuilder description(String description) {
        this.info.withDescription(description);
        return this;
    }

    public ParameterBuilder experimentalFeature() {
        this.info.withExperimentalFeature();
        return this;
    }

    public ParameterBuilder docDefaultValue(Object defaultValue) {
        this.docDefaultValue = defaultValue;
        return this;
    }

    public Boolean asBoolean() {
        return this.ofRequired(ConfigType.BOOLEAN).asBoolean();
    }

    public Boolean asBoolean(boolean defaultValue) {
        return this.ofOptional(ConfigType.BOOLEAN, defaultValue, JsonNode::asBoolean);
    }

    public double asDouble() {
        return this.ofRequired(ConfigType.DOUBLE).asDouble();
    }

    public double asDouble(double defaultValue) {
        return this.ofOptional(ConfigType.DOUBLE, defaultValue, JsonNode::asDouble);
    }

    public Optional<Double> asDoubleOptional() {
        return Optional.ofNullable(this.ofOptional(ConfigType.DOUBLE, null, JsonNode::asDouble));
    }

    public List<Double> asDoubles(List<Double> defaultValue) {
        return this.ofArrayAsList(ConfigType.DOUBLE, defaultValue, JsonNode::asDouble);
    }

    public int asInt() {
        return this.ofRequired(ConfigType.INTEGER).asInt();
    }

    public int asInt(int defaultValue) {
        return this.ofOptional(ConfigType.INTEGER, defaultValue, JsonNode::asInt);
    }

    public Gram asGram(Gram defaultValue) {
        return Gram.of(this.ofOptional(ConfigType.GRAM, defaultValue.toString(), JsonNode::asText));
    }

    public long asLong(long defaultValue) {
        return this.ofOptional(ConfigType.LONG, defaultValue, JsonNode::asLong);
    }

    public String asString() {
        return this.ofRequired(ConfigType.STRING).asText();
    }

    public String asString(String defaultValue) {
        return this.ofOptional(ConfigType.STRING, defaultValue, JsonNode::asText);
    }

    public Set<String> asStringSet(Collection<String> defaultValue) {
        List<String> dft = defaultValue instanceof List ? (List<String>)defaultValue : List.copyOf(defaultValue);
        return Set.copyOf(this.ofArrayAsList(ConfigType.STRING, dft, JsonNode::asText));
    }

    public List<String> asStringList(Collection<String> defaultValue) {
        List<String> dft = defaultValue instanceof List ? (List<String>)defaultValue : List.copyOf(defaultValue);
        return this.ofArrayAsList(ConfigType.STRING, dft, JsonNode::asText);
    }

    public Map<String, String> asStringMap() {
        return this.ofOptionalMap(ConfigType.STRING, JsonNode::asText);
    }

    public NodeAdapter asObject() {
        this.info.withOptional().withType(ConfigType.OBJECT);
        return this.buildObject();
    }

    public <T> List<T> asObjects(Function<NodeAdapter, T> mapper) {
        return this.asObjects(List.of(), mapper);
    }

    public <T> List<T> asObjects(List<T> defaultValues, Function<NodeAdapter, T> mapper) {
        this.setInfoOptional(defaultValues);
        this.info.withArray(ConfigType.OBJECT);
        return this.buildAndListComplexArrayElements(defaultValues, mapper);
    }

    @Deprecated
    public <T extends Enum<T>> T asEnum(Class<T> enumType) {
        this.info.withRequired().withEnum(enumType);
        return this.parseRequiredEnum(this.build().asText(), enumType);
    }

    public <T extends Enum<T>> T asEnum(T defaultValue) {
        this.info.withEnum(defaultValue.getClass());
        this.setInfoOptional(defaultValue);
        JsonNode node = this.build();
        if (node.isMissingNode()) {
            return defaultValue;
        }
        return (T)((Enum)this.parseOptionalEnum(node.asText(), defaultValue.getClass()).orElse(defaultValue));
    }

    public <T extends Enum<T>> Set<T> asEnumSet(Class<T> enumClass) {
        this.info.withOptional().withEnumSet(enumClass);
        List<Optional> optionalList = this.buildAndListSimpleArrayElements(List.of(), it -> this.parseOptionalEnum(it.asText(), enumClass));
        List<Enum> result = optionalList.stream().filter(Optional::isPresent).map(Optional::get).toList();
        return result.isEmpty() ? Set.of() : Set.copyOf(result);
    }

    public <T extends Enum<T>> Set<T> asEnumSet(Class<T> enumClass, Collection<T> defaultValues) {
        List<T> dft = defaultValues instanceof List ? (List<T>)defaultValues : List.copyOf(defaultValues);
        this.info.withOptional(dft.toString()).withEnumSet(enumClass);
        List<Optional> optionalList = this.buildAndListSimpleArrayElements(List.of(), it -> this.parseOptionalEnum(it.asText(), enumClass));
        List<Enum> result = optionalList.stream().filter(Optional::isPresent).map(Optional::get).toList();
        return result.isEmpty() ? Set.copyOf(dft) : Set.copyOf(result);
    }

    public <T, E extends Enum<E>> Map<E, T> asEnumMap(Class<E> enumType, Class<T> elementJavaType) {
        ConfigType elementType = ConfigType.of(elementJavaType);
        this.info.withOptional().withEnumMap(enumType, elementType);
        NodeAdapter mapNode = this.buildObject();
        if (mapNode.isEmpty()) {
            return Map.of();
        }
        EnumMap<E, T> result = new EnumMap<E, T>(enumType);
        Iterator<String> it = mapNode.listExistingChildNodes();
        while (it.hasNext()) {
            String name = it.next();
            Optional<E> key = this.parseOptionalEnum(name, enumType);
            if (!key.isPresent()) continue;
            JsonNode child = mapNode.rawNode(name);
            result.put((E)((Enum)key.get()), this.parseConfigType(elementType, child));
        }
        return result;
    }

    public <T, E extends Enum<E>> Map<E, T> asEnumMap(Class<E> enumType, Function<NodeAdapter, T> typeMapper, Map<E, T> defaultValue) {
        this.info.withOptional().withEnumMap(enumType, ConfigType.OBJECT);
        NodeAdapter mapNode = this.buildObject();
        if (mapNode.isEmpty()) {
            return defaultValue;
        }
        EnumMap<E, T> result = new EnumMap<E, T>(enumType);
        Iterator<String> it = mapNode.listExistingChildNodes();
        while (it.hasNext()) {
            String name = it.next();
            Optional<E> key = this.parseOptionalEnum(name, enumType);
            if (!key.isPresent()) continue;
            NodeAdapter child = mapNode.pathUndocumentedChild(name, this.info.since());
            result.put((E)((Enum)key.get()), typeMapper.apply(child));
        }
        return result;
    }

    public <T, E extends Enum<E>> Map<E, T> asEnumMapAllKeysRequired(Class<E> enumType, Class<T> elementJavaType) {
        Map<E, T> map = this.asEnumMap(enumType, elementJavaType);
        if (map.isEmpty()) {
            return null;
        }
        EnumSet<E> reminding = EnumSet.allOf(enumType);
        reminding.removeAll(map.keySet());
        if (!reminding.isEmpty()) {
            throw this.error("The following enum map keys are missing: %s".formatted(reminding));
        }
        return map;
    }

    public <T> T asCustomStringType(T defaultValue, String defaultValueAsString, Function<String, T> mapper) {
        return (T)this.ofOptional(ConfigType.STRING, defaultValue, node -> mapper.apply(node.asText()), it -> defaultValueAsString);
    }

    public LocalDate asDateOrRelativePeriod(String defaultValue, ZoneId timeZone) {
        return this.ofOptionalString(ConfigType.DURATION, defaultValue, s -> this.parseRelativeLocalDate((String)s, timeZone));
    }

    public Duration asDuration(Duration defaultValue) {
        return this.ofOptional(ConfigType.DURATION, defaultValue, node -> this.parseDuration(node.asText()));
    }

    public Duration asDuration() {
        return this.ofRequired(ConfigType.DURATION, node -> this.parseDuration(node.asText()));
    }

    public Duration asDurationOrSeconds(Duration defaultValue) {
        this.info.withType(ConfigType.DURATION);
        this.setInfoOptional(defaultValue.toString());
        JsonNode node = this.build();
        if (node.isTextual()) {
            return this.asDuration(defaultValue);
        }
        return Duration.ofSeconds((long)this.asDouble(defaultValue.toSeconds()));
    }

    public List<Duration> asDurations(List<Duration> defaultValues) {
        return this.ofArrayAsList(ConfigType.DURATION, defaultValues, node -> this.parseDuration(node.asText()));
    }

    public Locale asLocale(Locale defaultValue) {
        return this.ofOptional(ConfigType.LOCALE, defaultValue, jsonNode -> this.parseLocale(jsonNode.asText()));
    }

    public Pattern asPattern(String defaultValue) {
        return this.ofOptionalString(ConfigType.REGEXP, defaultValue, Pattern::compile);
    }

    public URI asUri() {
        return this.ofRequired(ConfigType.URI, n -> this.parseUri(n.asText()));
    }

    public URI asUri(String defaultValue) {
        return this.ofOptionalString(ConfigType.URI, defaultValue, this::parseUri);
    }

    public List<URI> asUris() {
        return this.ofArrayAsList(ConfigType.URI, List.of(), n -> this.parseUri(n.asText()));
    }

    public ZoneId asZoneId(ZoneId defaultValue) {
        return this.ofOptional(ConfigType.TIME_ZONE, defaultValue, n -> this.parseZoneId(n.asText()));
    }

    public FeedScopedId asFeedScopedId(FeedScopedId defaultValue) {
        return this.exist() ? FeedScopedId.parse(this.ofType(ConfigType.FEED_SCOPED_ID).asText()) : defaultValue;
    }

    public List<FeedScopedId> asFeedScopedIds(List<FeedScopedId> defaultValues) {
        this.setInfoOptional(defaultValues);
        this.info.withArray(ConfigType.FEED_SCOPED_ID);
        return this.buildAndListSimpleArrayElements(defaultValues, it -> FeedScopedId.parse(it.asText()));
    }

    public CostLinearFunction asCostLinearFunction(CostLinearFunction defaultValue) {
        return this.ofOptional(ConfigType.COST_LINEAR_FUNCTION, defaultValue, n -> CostLinearFunction.of(n.asText()));
    }

    public TimePenalty asTimePenalty(TimePenalty defaultValue) {
        return this.ofOptional(ConfigType.TIME_PENALTY, defaultValue, n -> TimePenalty.of(n.asText()));
    }

    private String paramName() {
        return this.info.name();
    }

    private boolean exist() {
        return this.target.exist(this.paramName());
    }

    private JsonNode ofType(ConfigType type) {
        this.info.withType(type);
        return this.build();
    }

    private <T> T ofType(ConfigType type, Function<JsonNode, T> body) {
        this.info.withType(type);
        return body.apply(this.build());
    }

    private JsonNode ofRequired(ConfigType type) {
        this.info.withRequired();
        return this.ofType(type);
    }

    private <T> T ofRequired(ConfigType type, Function<JsonNode, T> body) {
        this.info.withRequired();
        return this.ofType(type, body);
    }

    private <T> T ofOptional(ConfigType type, T defaultValue, Function<JsonNode, T> body, Function<T, String> toText) {
        this.setInfoOptional(defaultValue == null ? null : toText.apply(defaultValue));
        this.info.withType(type);
        JsonNode node = this.build();
        return this.exist() ? body.apply(node) : defaultValue;
    }

    private <T> T ofOptional(ConfigType type, T defaultValue, Function<JsonNode, T> body) {
        return (T)this.ofOptional(type, defaultValue, body, String::valueOf);
    }

    private <T> T ofOptionalString(ConfigType type, String defaultValueAsString, Function<String, T> mapper) {
        this.setInfoOptional(defaultValueAsString);
        this.info.withType(type);
        JsonNode node = this.build();
        return this.exist() ? (T)mapper.apply(node.asText()) : (defaultValueAsString == null ? null : (T)mapper.apply(defaultValueAsString));
    }

    private <T> List<T> ofArrayAsList(ConfigType elementType, List<T> defaultValue, Function<JsonNode, T> mapper) {
        this.setInfoOptional(defaultValue);
        this.info.withArray(elementType);
        return this.buildAndListSimpleArrayElements(defaultValue, mapper);
    }

    private <T> Map<String, T> ofOptionalMap(ConfigType elementType, Function<JsonNode, T> mapper) {
        this.info.withOptional().withMap(elementType);
        NodeAdapter mapNode = this.buildObject();
        if (mapNode.isEmpty()) {
            return Map.of();
        }
        HashMap<String, T> result = new HashMap<String, T>();
        Iterator<String> names = mapNode.parameterNames();
        while (names.hasNext()) {
            String parameterName = names.next();
            result.put(parameterName, mapper.apply(mapNode.rawNode(parameterName)));
        }
        return result;
    }

    private JsonNode build() {
        this.docDefaultValue = null;
        return this.target.addAndValidateParameterNode(this.info.build());
    }

    private NodeAdapter buildObject() {
        JsonNode node = this.build();
        return this.target.path(this.paramName(), node);
    }

    private <T> List<T> buildAndListSimpleArrayElements(List<T> defaultValues, Function<JsonNode, T> mapper) {
        JsonNode array = this.build();
        if (array.isMissingNode()) {
            return defaultValues;
        }
        if (!array.isArray()) {
            throw this.error("The parameter is not a JSON array as expected.");
        }
        ArrayList<T> values = new ArrayList<T>();
        for (JsonNode node : array) {
            values.add(mapper.apply(node));
        }
        return values;
    }

    private <T> List<T> buildAndListComplexArrayElements(List<T> defaultValues, Function<NodeAdapter, T> parse) {
        JsonNode array = this.build();
        if (array.isMissingNode()) {
            return defaultValues;
        }
        if (!array.isArray()) {
            throw this.error("The parameter is not a JSON array as expected.");
        }
        ArrayList<T> values = new ArrayList<T>();
        int i = 0;
        NodeAdapter arrayAdaptor = this.target.path(this.paramName(), array);
        for (JsonNode node : array) {
            NodeAdapter element = arrayAdaptor.path("[" + i + "]", node);
            values.add(parse.apply(element));
            ++i;
        }
        return values;
    }

    private void setInfoOptional(Object realDefaultValue) {
        this.info.withOptional(this.getDocDefaultValue(realDefaultValue));
    }

    private String getDocDefaultValue(Object realDefaultValue) {
        List list;
        Object value;
        Object object = value = this.docDefaultValue == UNDEFINED ? realDefaultValue : this.docDefaultValue;
        if (value == null) {
            return null;
        }
        if (value instanceof List && (list = (List)value).isEmpty()) {
            return "[]";
        }
        if (value instanceof Enum) {
            Enum enumValue = (Enum)value;
            return EnumMapper.toString(enumValue);
        }
        return String.valueOf(value);
    }

    private <T> T parseConfigType(ConfigType elementType, JsonNode child) {
        try {
            return elementType.valueOf(child);
        }
        catch (Exception e) {
            throw this.error("The parameter value '%s' is not of type %s.".formatted(child.asText(), elementType.docName()), e);
        }
    }

    private <E extends Enum<E>> E parseRequiredEnum(String value, Class<E> ofType) {
        return (E)((Enum)EnumMapper.mapToEnum(value, ofType).orElseThrow(() -> {
            throw this.error("The parameter value '%s' is not legal. Expected one of %s.".formatted(value, List.of((Enum[])ofType.getEnumConstants())));
        }));
    }

    private <E extends Enum<E>> Optional<E> parseOptionalEnum(String value, Class<E> ofType) {
        Optional<E> enumValue = EnumMapper.mapToEnum(value, ofType);
        if (enumValue.isEmpty()) {
            this.warning("The enum value '%s' is not legal. Expected one of %s.".formatted(value, List.of((Enum[])ofType.getEnumConstants())));
            return Optional.empty();
        }
        return enumValue;
    }

    private LocalDate parseRelativeLocalDate(String value, ZoneId zoneId) {
        try {
            return LocalDateUtils.asRelativeLocalDate((String)value, (LocalDate)LocalDate.now(zoneId));
        }
        catch (DateTimeParseException e) {
            throw this.error("The parameter value '%s' is not a Period or LocalDate.".formatted(value), e);
        }
    }

    private Duration parseDuration(String value) {
        try {
            return DurationUtils.duration((String)value);
        }
        catch (DateTimeParseException e) {
            throw this.error("The parameter value '%s' is not a duration.".formatted(value), e);
        }
    }

    private Locale parseLocale(String text) {
        String[] parts = text.split("[-_ ]+");
        return switch (parts.length) {
            case 1 -> new Locale(parts[0]);
            case 2 -> new Locale(parts[0], parts[1]);
            case 3 -> new Locale(parts[0], parts[1], parts[2]);
            default -> throw this.error("The parameter is not a valid Locale: '" + text + "'. Use: <Language>[_<country>[_<variant>]].");
        };
    }

    private URI parseUri(String text) {
        try {
            if (text == null || text.isBlank()) {
                return null;
            }
            return new URI(text);
        }
        catch (URISyntaxException e) {
            throw this.error("Unable to parse URI parameter value '%s'. Not parsable by java.net.URI class.".formatted(text), e);
        }
    }

    private ZoneId parseZoneId(String text) {
        try {
            return ZoneId.of(text);
        }
        catch (DateTimeException e) {
            throw this.error("Unable to parse parameter value: '" + text + "'. Expected a value parsable by java.time.ZoneId class.");
        }
    }

    private OtpAppException error(String message) {
        return this.target.createException(message, this.paramName());
    }

    private OtpAppException error(String message, Exception e) {
        return this.target.createException(message, this.paramName(), e);
    }

    private void warning(String message) {
        this.target.addWarning(message, this.paramName());
    }
}

