/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.config.framework.json;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.opentripplanner.standalone.config.framework.json.ConfigType;
import org.opentripplanner.standalone.config.framework.json.NodeInfoBuilder;
import org.opentripplanner.standalone.config.framework.json.OtpVersion;
import org.opentripplanner.utils.lang.StringUtils;
import org.opentripplanner.utils.tostring.ValueObjectToStringBuilder;

public record NodeInfo(String name, String summary, @Nullable String description, ConfigType type, @Nullable Class<? extends Enum<?>> enumType, @Nullable ConfigType elementType, OtpVersion since, @Nullable String defaultValue, boolean required, boolean skipChild) implements Comparable<NodeInfo>
{
    static final String EXPERIMENTAL_FEATURE = "**THIS IS STILL AN EXPERIMENTAL FEATURE - IT MAY CHANGE WITHOUT ANY NOTICE!**";
    static final String TYPE_QUALIFIER = "type";
    static final String SOURCETYPE_QUALIFIER = "sourceType";

    public NodeInfo {
        Objects.requireNonNull(name);
        Objects.requireNonNull(type);
        Objects.requireNonNull(since);
        Objects.requireNonNull(summary);
        if (type.isMapOrArray()) {
            Objects.requireNonNull(elementType);
        }
    }

    static NodeInfo ofSkipChild(String name) {
        return NodeInfo.of().withName(name).withSummary("No doc, parent contains doc.").withType(ConfigType.OBJECT).withSince(OtpVersion.NA).withOptional().withSkipChild().build();
    }

    public NodeInfo arraysChild() {
        return NodeInfo.of().withName("{ object }").withSummary("Nested object in array. The object type is determined by the parameters.").withType(this.elementType).withSince(this.since).withOptional().build();
    }

    public boolean printDetails() {
        return (this.description != null || this.enumType != null || this.elementType != null) && !this.isTypeQualifier();
    }

    static NodeInfoBuilder of() {
        return new NodeInfoBuilder();
    }

    public String typeDescription() {
        return switch (this.type) {
            case ConfigType.ARRAY -> this.elementType.docName() + "[]";
            case ConfigType.MAP -> "map of " + this.elementType.docName();
            case ConfigType.ENUM_MAP -> "enum map of " + this.elementType.docName();
            case ConfigType.ENUM_SET -> "enum set";
            default -> this.type.docName();
        };
    }

    public boolean isTypeQualifier() {
        return this.enumType != null && TYPE_QUALIFIER.equalsIgnoreCase(this.name);
    }

    public List<? extends Enum<?>> enumTypeValues() {
        return this.enumType == null ? List.of() : Arrays.stream(this.enumType.getEnumConstants()).toList();
    }

    public String toMarkdownString(Object value) {
        if (this.enumType != null) {
            value = StringUtils.kebabCase((String)value.toString());
        }
        return this.type.quote(value);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeInfo leafNode = (NodeInfo)o;
        return Objects.equals(this.name, leafNode.name);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name);
    }

    @Override
    public String toString() {
        ValueObjectToStringBuilder builder = ValueObjectToStringBuilder.of().addText(this.name).addText(" : ").addText(this.typeDescription());
        if (this.required) {
            builder.addText(" Required");
        } else if (this.defaultValue != null) {
            builder.addText(" = ").addText(this.type.quote(this.defaultValue));
        } else {
            builder.addText(" Optional");
        }
        builder.addText(" Since ").addText(this.since.toString());
        return builder.toString();
    }

    @Override
    public int compareTo(NodeInfo other) {
        if (this.isTypeQualifier()) {
            return -1;
        }
        if (other.isTypeQualifier()) {
            return 1;
        }
        if (this.type.isSimple() != other.type.isSimple()) {
            return this.type.isSimple() ? -1 : 1;
        }
        return this.name.compareTo(other.name);
    }
}

