/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.config.framework.json;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.opentripplanner.framework.application.OtpAppException;
import org.opentripplanner.standalone.config.framework.json.NodeInfo;
import org.opentripplanner.standalone.config.framework.json.OtpVersion;
import org.opentripplanner.standalone.config.framework.json.ParameterBuilder;

public class NodeAdapter {
    private final JsonNode json;
    private final String source;
    private final String contextPath;
    private final Map<String, NodeAdapter> childrenByName = new HashMap<String, NodeAdapter>();
    private final Map<String, NodeInfo> parameters = new HashMap<String, NodeInfo>();
    private final List<String> warnings = new ArrayList<String>();
    private boolean usedAsRaw = false;
    private final int level;

    private NodeAdapter(JsonNode node, String source, String contextPath, int level) {
        this.json = node;
        this.source = source;
        this.contextPath = contextPath;
        this.level = level;
    }

    public NodeAdapter(JsonNode node, String source) {
        this(node, source, null, 0);
    }

    private NodeAdapter(JsonNode node, NodeAdapter parent, String paramName) {
        this(node, parent.source, parent.fullPath(paramName), parent.level + 1);
        parent.childrenByName.put(paramName, this);
    }

    public String contextPath() {
        return this.contextPath;
    }

    public String source() {
        return this.source;
    }

    public boolean isNonEmptyArray() {
        return this.json.isArray() && this.json.size() > 0;
    }

    public boolean isObject() {
        return this.json.isObject() && this.json.size() > 0;
    }

    public List<NodeInfo> parametersSorted() {
        return this.parameters.values().stream().sorted().toList();
    }

    public NodeAdapter child(String paramName) {
        return this.childrenByName.get(paramName);
    }

    public ParameterBuilder of(String paramName) {
        return new ParameterBuilder(this, paramName);
    }

    public boolean isEmpty() {
        return this.json.isMissingNode();
    }

    public boolean exist(String paramName) {
        return this.json.has(paramName);
    }

    public String asText() {
        return this.json.asText();
    }

    public Iterator<String> parameterNames() {
        return this.json.fieldNames();
    }

    public Iterator<String> listExistingChildNodes() {
        return this.json.fieldNames();
    }

    public List<String> listChildrenByName() {
        return this.childrenByName.keySet().stream().sorted().toList();
    }

    public String typeQualifier() {
        this.assertRequiredFieldExist("type");
        return this.json.path("type").asText();
    }

    public String sourceTypeQualifier() {
        this.assertRequiredFieldExist("sourceType");
        return this.json.path("sourceType").asText();
    }

    public void logAllWarnings(Consumer<String> logger) {
        for (String p : this.unusedParams()) {
            logger.accept("Unexpected config parameter: '" + p + "' in '" + this.source + "'");
        }
        this.allWarnings().forEach(logger);
    }

    public boolean hasUnknownParameters() {
        return !this.unusedParams().isEmpty();
    }

    public JsonNode rawNode() {
        this.usedAsRaw = true;
        return this.json;
    }

    public int level() {
        return this.level;
    }

    JsonNode rawNode(String paramName) {
        this.parameters.put(paramName, NodeInfo.ofSkipChild(paramName));
        return this.json.path(paramName);
    }

    public String toJson() {
        return this.json.toString();
    }

    public String toPrettyString() {
        return this.json.toPrettyString();
    }

    NodeAdapter path(String paramName, JsonNode node) {
        if (this.childrenByName.containsKey(paramName)) {
            return this.childrenByName.get(paramName);
        }
        return new NodeAdapter(node, this, paramName);
    }

    NodeAdapter pathUndocumentedChild(String paramName, OtpVersion since) {
        return this.of(paramName).since(since).summary("NA").asObject();
    }

    private List<String> unusedParams() {
        if (this.usedAsRaw) {
            return List.of();
        }
        ArrayList<String> unusedParams = new ArrayList<String>();
        Iterator it = this.json.fieldNames();
        Set<String> parameterNames = this.parameters.keySet();
        while (it.hasNext()) {
            String fieldName = (String)it.next();
            if (parameterNames.contains(fieldName)) continue;
            unusedParams.add(this.fullPath(fieldName) + ":" + String.valueOf(this.json.get(fieldName)));
        }
        for (NodeAdapter c : this.childrenByName.values()) {
            unusedParams.addAll(c.unusedParams());
        }
        unusedParams.sort(String::compareTo);
        return unusedParams;
    }

    JsonNode addAndValidateParameterNode(NodeInfo info) {
        this.addParameterInfo(info);
        if (info.required()) {
            this.assertRequiredFieldExist(info.name());
        }
        return this.json.path(info.name());
    }

    public String fullPath(String paramName) {
        return this.contextPath == null ? paramName : this.concatPath(this.contextPath, paramName);
    }

    String concatPath(String a, String b) {
        return a + "." + b;
    }

    public void addWarning(String message, String paramName) {
        message = (String)message + " Parameter: " + this.fullPath(paramName) + ".";
        message = (String)message + " Source: " + this.source + ".";
        this.warnings.add((String)message);
    }

    public OtpAppException createException(String message, String paramName) {
        message = (String)message + " Parameter: " + this.fullPath(paramName) + ".";
        message = (String)message + " Source: " + this.source + ".";
        return new OtpAppException((String)message);
    }

    public OtpAppException createException(String message, String paramName, Exception cause) {
        message = (String)message + " Details: " + cause.getMessage();
        return this.createException((String)message, paramName);
    }

    private Stream<String> allWarnings() {
        Stream childrenWarnings = this.childrenByName.values().stream().flatMap(NodeAdapter::allWarnings);
        return Stream.concat(childrenWarnings, this.warnings.stream());
    }

    private void addParameterInfo(NodeInfo info) {
        if (this.parameters.containsKey(info.name())) {
            this.assertParameterInfoIsEqual(info);
        } else {
            this.parameters.put(info.name(), info);
        }
    }

    private void assertRequiredFieldExist(String paramName) {
        if (!this.exist(paramName)) {
            throw this.requiredFieldMissingException(paramName);
        }
    }

    private void assertParameterInfoIsEqual(NodeInfo info) {
        NodeInfo other = this.parameters.get(info.name());
        if (!other.equals(info)) {
            throw new OtpAppException("Two different parameter definitions exist: " + String.valueOf(other) + " != " + String.valueOf(info));
        }
    }

    private OtpAppException requiredFieldMissingException(String paramName) {
        return new OtpAppException("Required parameter '" + this.fullPath(paramName) + "' not found in '" + this.source + "'.");
    }
}

