/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.config.framework.json;

import java.util.Arrays;
import java.util.Optional;
import org.opentripplanner.framework.doc.DocumentedEnum;
import org.opentripplanner.utils.lang.StringUtils;

public class EnumMapper {
    public static <E extends Enum<E>> Optional<E> mapToEnum(String text, Class<E> type) {
        return EnumMapper.mapToEnum2(text, type);
    }

    public static Optional<? extends Enum<?>> mapToEnum2(String text, Class<? extends Enum<?>> type) {
        if (text == null) {
            return Optional.empty();
        }
        String name = text.toUpperCase().replace('-', '_');
        return Arrays.stream(type.getEnumConstants()).filter(it -> it.name().toUpperCase().equals(name)).findFirst();
    }

    public static String toString(Enum<?> en) {
        return StringUtils.kebabCase((String)en.name());
    }

    public static <T extends DocumentedEnum> String docEnumValueList(T[] enumValues) {
        StringBuilder buf = new StringBuilder();
        for (T it : enumValues) {
            buf.append(" - `").append(EnumMapper.toString((Enum)it)).append("` ").append(it.enumValueDescription().replace("\n", "\n   ").trim()).append("\n");
        }
        return buf.toString();
    }
}

