/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.config.buildconfig;

import org.opentripplanner.graph_builder.module.TransferParameters;
import org.opentripplanner.standalone.config.framework.json.NodeAdapter;
import org.opentripplanner.standalone.config.framework.json.OtpVersion;

public class TransferParametersMapper {
    public static TransferParameters map(NodeAdapter c) {
        TransferParameters.Builder builder = new TransferParameters.Builder();
        builder.withMaxTransferDuration(c.of("maxTransferDuration").summary("This overwrites the default `maxTransferDuration` for the given mode.").since(OtpVersion.V2_7).asDuration(TransferParameters.DEFAULT_MAX_TRANSFER_DURATION));
        builder.withCarsAllowedStopMaxTransferDuration(c.of("carsAllowedStopMaxTransferDuration").summary("This is used for specifying a `maxTransferDuration` value to use with transfers between stops which are visited by trips that allow cars.").description("This parameter configures additional transfers to be calculated for the specified mode only between stops that have trips with cars.\nThe transfers are calculated for the mode in a range based on the given duration.\nBy default, these transfers are not calculated unless specified for a mode with this field.\n\nCalculating transfers only between stops that have trips with cars can be useful with car ferries, for example.\nUsing transit with cars can only occur between certain stops.\nThese kinds of stops require support for loading cars into ferries, for example.\nThe default transfers are calculated based on a configurable range (configurable by using the `maxTransferDuration` field)\nwhich limits transfers from stops to only be calculated to other stops that are in range.\nWhen compared to walking, using a car can cover larger distances within the same duration specified in the `maxTransferDuration` field.\nThis can lead to large amounts of transfers calculated between stops that do not require car transfers between them.\nThis in turn can lead to a large increase in memory for the stored graph, depending on the data used in the graph.\n\nFor cars, using this parameter in conjunction with `disableDefaultTransfers` allows calculating transfers only between relevant stops.\nFor bikes, using this parameter can enable transfers between ferry stops that would normally not be in range.\nIn Finland this is useful for bike routes that use ferries near the Turku archipelago, for example.\n").since(OtpVersion.V2_7).asDuration(TransferParameters.DEFAULT_CARS_ALLOWED_STOP_MAX_TRANSFER_DURATION));
        builder.withDisableDefaultTransfers(c.of("disableDefaultTransfers").summary("This disables default transfer calculations.").description("The default transfers are calculated based on a configurable range (configurable by using the `maxTransferDuration` field)\nwhich limits transfers from stops to only be calculated to other stops that are in range.\nThis parameter disables these transfers.\nA motivation to disable default transfers could be related to using the `carsAllowedStopMaxTransferDuration` field which only\ncalculates transfers between stops that have trips with cars.\nFor example, when using the `carsAllowedStopMaxTransferDuration` field with cars, the default transfers can be redundant.\n").since(OtpVersion.V2_7).asBoolean(false));
        return builder.build();
    }
}

