/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.config.buildconfig;

import java.util.EnumMap;
import java.util.Map;
import org.opentripplanner.graph_builder.module.TransferParameters;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.standalone.config.buildconfig.TransferParametersMapper;
import org.opentripplanner.standalone.config.framework.json.NodeAdapter;
import org.opentripplanner.standalone.config.framework.json.OtpVersion;

public class TransferConfig {
    public static Map<StreetMode, TransferParameters> map(NodeAdapter root, String parameterName) {
        return root.of(parameterName).since(OtpVersion.V2_7).summary("Configures mode-specific properties for transfer calculations.").description("This field enables configuring mode-specific parameters for transfer calculations.\nTo configure mode-specific parameters, the modes should also be used in the `transferRequests` field in the build config.\n\n**Example**\n\n```JSON\n// build-config.json\n{\n  \"transferParametersForMode\": {\n    \"CAR\": {\n      \"disableDefaultTransfers\": true,\n      \"carsAllowedStopMaxTransferDuration\": \"3h\"\n    },\n    \"BIKE\": {\n      \"maxTransferDuration\": \"30m\",\n      \"carsAllowedStopMaxTransferDuration\": \"3h\"\n    }\n  }\n}\n```\n").asEnumMap(StreetMode.class, TransferParametersMapper::map, new EnumMap(StreetMode.class));
    }
}

