/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.config.buildconfig;

import org.opentripplanner.framework.application.OtpAppException;
import org.opentripplanner.standalone.config.framework.json.NodeAdapter;
import org.opentripplanner.standalone.config.framework.json.OtpVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3BucketConfig {
    private static final Logger LOG = LoggerFactory.getLogger(S3BucketConfig.class);
    public String accessKey;
    public String secretKey;
    public String bucketName;

    public static S3BucketConfig fromConfig(NodeAdapter root, String elevationBucketName) {
        return S3BucketConfig.fromConfig(root.of(elevationBucketName).since(OtpVersion.NA).summary("Used to download NED elevation tiles from the given AWS S3 bucket.").description("In the United States, a high resolution [National Elevation Dataset](http://ned.usgs.gov/) is\navailable for the entire territory. It used to be possible for OTP to download NED tiles on the fly\nfrom a rather complex USGS SOAP service. This process was somewhat unreliable and would greatly slow\ndown the graph building process. In any case the service has since been replaced. But the USGS would\nalso deliver the whole dataset in bulk if you\n[sent them a hard drive](https://web.archive.org/web/20150811051917/http://ned.usgs.gov:80/faq.html#DATA).\nWe did this many years back and uploaded the entire data set to Amazon AWS S3. OpenTripPlanner\ncontains another module that can automatically fetch data in this format from any Amazon S3 copy of\nthe bulk data.\n\nThis `ned13` bucket is still available on S3 under a \"requester pays\" policy. As long as you specify\nvalid AWS account credentials you should be able to download tiles, and any bandwidth costs will be\nbilled to your AWS account.\n\nOnce the tiles are downloaded for a particular geographic area, OTP will keep them in local cache\nfor the next graph build operation. You should add the `--cache <directory>` command line parameter\nto specify your NED tile cache location.\n").asObject());
    }

    public static S3BucketConfig fromConfig(NodeAdapter config) {
        if (config.isEmpty()) {
            return null;
        }
        S3BucketConfig bucketConfig = new S3BucketConfig();
        try {
            bucketConfig.accessKey = config.of("accessKey").since(OtpVersion.NA).summary("Credentials: the Amazon Web Services access key").asString();
            bucketConfig.secretKey = config.of("secretKey").since(OtpVersion.NA).summary("Credentials: the Amazon Web Services secret key corresponding to the access key.").asString();
            bucketConfig.bucketName = config.of("bucketName").since(OtpVersion.NA).summary("The bucket from which you want to download.").asString();
        }
        catch (OtpAppException ex) {
            LOG.error("You must specify an accessKey, a secretKey, and a bucketName when configuring S3 download. " + ex.getMessage());
            throw ex;
        }
        return bucketConfig;
    }

    public String toString() {
        return "[AWS S3 bucket configuration: bucketName=" + this.bucketName + " accessKey=" + this.accessKey + " secretKey=***]";
    }
}

