/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.config.buildconfig;

import org.opentripplanner.graph_builder.module.osm.parameters.OsmExtractParameters;
import org.opentripplanner.graph_builder.module.osm.parameters.OsmExtractParametersBuilder;
import org.opentripplanner.graph_builder.module.osm.parameters.OsmExtractParametersList;
import org.opentripplanner.standalone.config.framework.json.NodeAdapter;
import org.opentripplanner.standalone.config.framework.json.OtpVersion;

public class OsmConfig {
    public static OsmExtractParameters mapOsmDefaults(NodeAdapter root, String parameterName) {
        OsmExtractParameters baseDefaults = OsmExtractParameters.DEFAULT;
        NodeAdapter osmDefaults = root.of(parameterName).since(OtpVersion.V2_2).summary("Default properties for OpenStreetMap feeds.").asObject();
        return OsmConfig.mapOsmGenericParameters(osmDefaults, baseDefaults, "").build();
    }

    public static OsmExtractParametersList mapOsmConfig(NodeAdapter root, String parameterName, OsmExtractParameters defaults) {
        return new OsmExtractParametersList(root.of(parameterName).since(OtpVersion.V2_2).summary("Configure properties for a given OpenStreetMap feed.").description("The osm section of build-config.json allows you to override the default behavior of scanning\nfor OpenStreetMap files in the base directory. You can specify data located outside the\nlocal filesystem (including cloud storage services) or at various different locations around\nthe local filesystem.\n").asObjects(nodeAdapter -> OsmConfig.mapOsmParameters(nodeAdapter, defaults)));
    }

    public static OsmExtractParameters mapOsmParameters(NodeAdapter node, OsmExtractParameters defaults) {
        String documentationAddition = " Overrides the value specified in `osmDefaults`.";
        return OsmConfig.mapOsmGenericParameters(node, defaults, documentationAddition).withSource(node.of("source").since(OtpVersion.V2_2).summary("The unique URI pointing to the data file.").asUri()).build();
    }

    public static OsmExtractParametersBuilder mapOsmGenericParameters(NodeAdapter node, OsmExtractParameters defaults, String documentationAddition) {
        OsmExtractParameters docDefaults = OsmExtractParameters.DEFAULT;
        return defaults.copyOf().withOsmTagMapper(node.of("osmTagMapping").since(OtpVersion.V2_2).summary("The named set of mapping rules applied when parsing OSM tags." + documentationAddition).docDefaultValue((Object)docDefaults.osmTagMapper()).asEnum(defaults.osmTagMapper())).withTimeZone(node.of("timeZone").since(OtpVersion.V2_2).summary("The timezone used to resolve opening hours in OSM data." + documentationAddition).docDefaultValue(docDefaults.timeZone()).asZoneId(defaults.timeZone())).withIncludeOsmSubwayEntrances(node.of("includeOsmSubwayEntrances").since(OtpVersion.V2_7).summary("Whether to include subway entrances from the OSM data." + documentationAddition).docDefaultValue(docDefaults.includeOsmSubwayEntrances()).asBoolean(defaults.includeOsmSubwayEntrances()));
    }
}

