/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.config.buildconfig;

import org.opentripplanner.gtfs.config.GtfsDefaultParameters;
import org.opentripplanner.gtfs.config.GtfsFeedParameters;
import org.opentripplanner.standalone.config.framework.json.NodeAdapter;
import org.opentripplanner.standalone.config.framework.json.OtpVersion;

public class GtfsConfig {
    public static GtfsDefaultParameters mapGtfsDefaultParameters(NodeAdapter root, String parameterName) {
        GtfsDefaultParameters baseDefaults = GtfsFeedParameters.DEFAULT;
        NodeAdapter node = root.of(parameterName).since(OtpVersion.V2_3).summary("The gtfsDefaults section allows you to specify default properties for GTFS files.").asObject();
        return GtfsConfig.mapGenericParameters(node, baseDefaults, "");
    }

    public static GtfsFeedParameters mapGtfsFeed(NodeAdapter node, GtfsDefaultParameters defaults) {
        String documentationAddition = " Overrides the value specified in `gtfsDefaults`.";
        GtfsDefaultParameters genericParameters = GtfsConfig.mapGenericParameters(node, defaults, documentationAddition);
        return genericParameters.withFeedInfo().withFeedId(node.of("feedId").since(OtpVersion.V2_2).summary("The unique ID for this feed. This overrides any feed ID defined within the feed itself.").asString(null)).withSource(node.of("source").since(OtpVersion.V2_2).summary("The unique URI pointing to the data file.").asUri()).build();
    }

    private static GtfsDefaultParameters mapGenericParameters(NodeAdapter node, GtfsDefaultParameters defaults, String documentationAddition) {
        GtfsDefaultParameters docDefaults = GtfsFeedParameters.DEFAULT;
        return defaults.copyOf().withStationTransferPreference(node.of("stationTransferPreference").since(OtpVersion.V2_3).summary("Should there be some preference or aversion for transfers at stops that are part of a station." + documentationAddition).description("This parameter sets the generic level of preference. What is the actual cost can be changed\nwith the `stopBoardAlightDuringTransferCost` parameter in the router configuration.\n").docDefaultValue((Object)docDefaults.stationTransferPreference()).asEnum(defaults.stationTransferPreference())).withDiscardMinTransferTimes(node.of("discardMinTransferTimes").since(OtpVersion.V2_3).summary("Should minimum transfer times in GTFS files be discarded." + documentationAddition).description("This is useful eg. when the minimum transfer time is only set for ticketing purposes,\nbut we want to calculate the transfers always from OSM data.\n").docDefaultValue(docDefaults.discardMinTransferTimes()).asBoolean(defaults.discardMinTransferTimes())).withBlockBasedInterlining(node.of("blockBasedInterlining").since(OtpVersion.V2_3).summary("Whether to create stay-seated transfers in between two trips with the same block id." + documentationAddition).docDefaultValue(docDefaults.blockBasedInterlining()).asBoolean(defaults.blockBasedInterlining())).withMaxInterlineDistance(node.of("maxInterlineDistance").since(OtpVersion.V2_3).summary("Maximal distance between stops in meters that will connect consecutive trips that are made with same vehicle." + documentationAddition).docDefaultValue(docDefaults.maxInterlineDistance()).asInt(defaults.maxInterlineDistance())).build();
    }
}

