/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.config.buildconfig;

import org.opentripplanner.graph_builder.module.ned.parameter.DemExtractParameters;
import org.opentripplanner.graph_builder.module.ned.parameter.DemExtractParametersBuilder;
import org.opentripplanner.graph_builder.module.ned.parameter.DemExtractParametersList;
import org.opentripplanner.standalone.config.framework.json.NodeAdapter;
import org.opentripplanner.standalone.config.framework.json.OtpVersion;

public class DemConfig {
    public static DemExtractParameters mapDemDefaultsConfig(NodeAdapter root, String parameterName) {
        DemExtractParameters baseDefaults = DemExtractParameters.DEFAULT;
        NodeAdapter demDefaults = root.of(parameterName).since(OtpVersion.V2_3).summary("Default properties for DEM extracts.").asObject();
        return DemConfig.mapGenericDemParameters(demDefaults, baseDefaults, "").build();
    }

    public static DemExtractParametersList mapDemConfig(NodeAdapter root, String parameterName, DemExtractParameters defaults) {
        return new DemExtractParametersList(root.of(parameterName).since(OtpVersion.V2_2).summary("Specify parameters for DEM extracts.").description("The dem section allows you to override the default behavior of scanning for elevation\nfiles in the [base directory](Configuration.md#Base-Directory). You can specify data\nlocated outside the local filesystem (including cloud storage services) or at various\ndifferent locations around the local filesystem.\n\nIf not specified OTP will fall back to auto-detection based on the directory provided on\nthe command line.\n").asObjects(nodeAdapter -> DemConfig.mapDemExtract(nodeAdapter, defaults)));
    }

    private static DemExtractParameters mapDemExtract(NodeAdapter config, DemExtractParameters defaults) {
        String documentationAddition = " Overrides the value specified in `demDefaults`.";
        return DemConfig.mapGenericDemParameters(config, defaults, documentationAddition).withSource(config.of("source").since(OtpVersion.V2_2).summary("The unique URI pointing to the data file.").asUri()).build();
    }

    private static DemExtractParametersBuilder mapGenericDemParameters(NodeAdapter node, DemExtractParameters defaults, String documentationAddition) {
        DemExtractParameters docDefaults = DemExtractParameters.DEFAULT;
        return defaults.copyOf().withElevationUnitMultiplier(node.of("elevationUnitMultiplier").since(OtpVersion.V2_3).summary("Specify a multiplier to convert elevation units from source to meters." + documentationAddition).description("Unit conversion multiplier for elevation values. No conversion needed if the elevation\nvalues are defined in meters in the source data. If, for example, decimetres are used\nin the source data, this should be set to 0.1.\n").docDefaultValue(docDefaults.elevationUnitMultiplier()).asDouble(defaults.elevationUnitMultiplier()));
    }
}

