/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.config;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import java.io.Serializable;
import java.util.List;
import org.opentripplanner.apis.gtfs.GtfsApiParameters;
import org.opentripplanner.ext.flex.FlexParameters;
import org.opentripplanner.ext.ridehailing.RideHailingServiceParameters;
import org.opentripplanner.ext.trias.config.TriasApiConfig;
import org.opentripplanner.ext.trias.parameters.TriasApiParameters;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.standalone.config.framework.json.NodeAdapter;
import org.opentripplanner.standalone.config.framework.json.OtpVersion;
import org.opentripplanner.standalone.config.routerconfig.RideHailingServicesConfig;
import org.opentripplanner.standalone.config.routerconfig.ServerConfig;
import org.opentripplanner.standalone.config.routerconfig.TransitRoutingConfig;
import org.opentripplanner.standalone.config.routerconfig.UpdatersConfig;
import org.opentripplanner.standalone.config.routerconfig.VectorTileConfig;
import org.opentripplanner.standalone.config.routerequest.RouteRequestConfig;
import org.opentripplanner.standalone.config.sandbox.FlexConfig;
import org.opentripplanner.standalone.config.sandbox.GtfsApiConfig;
import org.opentripplanner.standalone.config.sandbox.TransmodelAPIConfig;
import org.opentripplanner.updater.UpdatersParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouterConfig
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(RouterConfig.class);
    public static final RouterConfig DEFAULT = new RouterConfig((JsonNode)MissingNode.getInstance(), "DEFAULT", false);
    private final NodeAdapter root;
    private final String configVersion;
    private final ServerConfig server;
    private final RouteRequest routingRequestDefaults;
    private final TransitRoutingConfig transitConfig;
    private final UpdatersParameters updatersParameters;
    private final RideHailingServicesConfig rideHailingConfig;
    private final FlexConfig flexConfig;
    private final TransmodelAPIConfig transmodelApi;
    private final GtfsApiConfig gtfsApi;
    private final VectorTileConfig vectorTileConfig;
    private final TriasApiParameters triasApiParameters;

    public RouterConfig(JsonNode node, String source, boolean logUnusedParams) {
        this(new NodeAdapter(node, source), logUnusedParams);
    }

    RouterConfig(NodeAdapter root, boolean logUnusedParams) {
        this.root = root;
        this.configVersion = root.of("configVersion").since(OtpVersion.V2_1).summary("Deployment version of the *router-config.json*.").description("The config-version is a parameter which each OTP deployment may set to be able to query the\nOTP server and verify that it uses the correct version of the config. The version should be\ninjected into the config in the (continuous) deployment pipeline. How this is done, is up to\nthe deployment.\n\nThe config-version has no effect on OTP, and is provided as is on the API. There is no syntax\nor format check on the version and it can be any string.\n\nBe aware that OTP uses the config embedded in the loaded graph if no new config is provided.\n").asString(null);
        this.server = new ServerConfig("server", root);
        this.transmodelApi = new TransmodelAPIConfig("transmodelApi", root);
        this.gtfsApi = new GtfsApiConfig("gtfsApi", root);
        RouteRequest request = RouteRequestConfig.mapDefaultRouteRequest("routingDefaults", root);
        this.transitConfig = new TransitRoutingConfig("transit", root, request);
        this.routingRequestDefaults = request.copyOf().withMaxSearchWindow(this.transitConfig.maxSearchWindow()).buildDefault();
        this.updatersParameters = new UpdatersConfig(root);
        this.rideHailingConfig = new RideHailingServicesConfig(root);
        this.vectorTileConfig = VectorTileConfig.mapVectorTilesParameters(root, "vectorTiles");
        this.triasApiParameters = TriasApiConfig.mapParameters("triasApi", root);
        this.flexConfig = new FlexConfig(root, "flex");
        if (logUnusedParams && LOG.isWarnEnabled()) {
            root.logAllWarnings(arg_0 -> ((Logger)LOG).warn(arg_0));
        }
        this.server.validate(this.routingRequestDefaults.preferences().street().routingTimeout());
    }

    public String getConfigVersion() {
        return this.configVersion;
    }

    public ServerConfig server() {
        return this.server;
    }

    public TransmodelAPIConfig transmodelApi() {
        return this.transmodelApi;
    }

    public RouteRequest routingRequestDefaults() {
        return this.routingRequestDefaults;
    }

    public TransitRoutingConfig transitTuningConfig() {
        return this.transitConfig;
    }

    public UpdatersParameters updaterConfig() {
        return this.updatersParameters;
    }

    public List<RideHailingServiceParameters> rideHailingServiceParameters() {
        return this.rideHailingConfig.rideHailingServiceParameters();
    }

    public VectorTileConfig vectorTileConfig() {
        return this.vectorTileConfig;
    }

    public FlexParameters flexParameters() {
        return this.flexConfig;
    }

    public TriasApiParameters triasApiParameters() {
        return this.triasApiParameters;
    }

    public GtfsApiParameters gtfsApiParameters() {
        return this.gtfsApi;
    }

    public NodeAdapter asNodeAdapter() {
        return this.root;
    }

    public boolean isDefault() {
        return this.root.isEmpty();
    }

    public String toJson() {
        return this.root.isEmpty() ? "" : this.root.toJson();
    }

    public String toString() {
        return this.root.toPrettyString();
    }

    public boolean hasUnknownParameters() {
        return this.root.hasUnknownParameters();
    }
}

