/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.config;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import java.util.List;
import org.opentripplanner.standalone.config.debuguiconfig.BackgroundTileLayer;
import org.opentripplanner.standalone.config.framework.json.NodeAdapter;
import org.opentripplanner.standalone.config.framework.json.OtpVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugUiConfig {
    private static final Logger LOG = LoggerFactory.getLogger(DebugUiConfig.class);
    public static final DebugUiConfig DEFAULT = new DebugUiConfig((JsonNode)MissingNode.getInstance(), "DEFAULT", false);
    private final NodeAdapter root;
    private final List<BackgroundTileLayer> additionalBackgroundLayers;

    public DebugUiConfig(JsonNode node, String source, boolean logUnusedParams) {
        this(new NodeAdapter(node, source), logUnusedParams);
    }

    DebugUiConfig(NodeAdapter root, boolean logUnusedParams) {
        this.root = root;
        this.additionalBackgroundLayers = root.of("additionalBackgroundLayers").since(OtpVersion.V2_7).summary("Additional background raster map layers.").description("Add additional background layers that will appear in the Debug UI as one of the choices.\n\nCurrently only raster tile layers are supported.\n").asObjects(List.of(), node -> new BackgroundTileLayer(node.of("name").since(OtpVersion.V2_7).summary("Name to appear in the layer selector.").asString(), node.of("templateUrl").since(OtpVersion.V2_7).summary("The [Maplibre-compatible template URL](https://maplibre.org/maplibre-native/ios/api/tile-url-templates.html)\nfor the raster layer, for example `https://examples.com/tiles/{z}/{x}/{y}.png`.\n").asString(), node.of("tileSize").since(OtpVersion.V2_7).summary("Size of the tile in pixels.").asInt(256), node.of("attribution").since(OtpVersion.V2_7).summary("Attribution for the map data.").asString("\u00a9 OpenTripPlanner")));
        if (logUnusedParams) {
            root.logAllWarnings(arg_0 -> ((Logger)LOG).warn(arg_0));
        }
    }

    public NodeAdapter asNodeAdapter() {
        return this.root;
    }

    public List<BackgroundTileLayer> additionalBackgroundLayers() {
        return this.additionalBackgroundLayers;
    }

    public boolean isDefault() {
        return this.root.isEmpty();
    }

    public boolean hasUnknownParameters() {
        return this.root.hasUnknownParameters();
    }
}

