/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.config;

import org.opentripplanner.framework.application.OTPFeature;
import org.opentripplanner.framework.application.OtpAppException;
import org.opentripplanner.standalone.config.BuildConfig;
import org.opentripplanner.standalone.config.DebugUiConfig;
import org.opentripplanner.standalone.config.OtpConfig;
import org.opentripplanner.standalone.config.OtpConfigLoader;
import org.opentripplanner.standalone.config.RouterConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigModel {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigModel.class);
    private final OtpConfig otpConfig;
    private BuildConfig buildConfig;
    private RouterConfig routerConfig;
    private final DebugUiConfig debugUiConfig;

    public ConfigModel(OtpConfig otpConfig, BuildConfig buildConfig, RouterConfig routerConfig, DebugUiConfig debugUiConfig) {
        this.otpConfig = otpConfig;
        this.buildConfig = buildConfig;
        this.routerConfig = routerConfig;
        this.debugUiConfig = debugUiConfig;
        ConfigModel.initializeOtpFeatures(otpConfig);
    }

    public ConfigModel(OtpConfigLoader loader) {
        this(loader.loadOtpConfig(), loader.loadBuildConfig(), loader.loadRouterConfig(), loader.loadDebugUiConfig());
    }

    public void updateConfigFromSerializedGraph(BuildConfig buildConfig, RouterConfig routerConfig) {
        if (this.buildConfig.isDefault()) {
            LOG.info("Using the graph embedded JSON build configuration.");
            this.buildConfig = buildConfig;
        }
        if (this.routerConfig.isDefault()) {
            LOG.info("Using the graph embedded JSON router configuration.");
            this.routerConfig = routerConfig;
        }
        OtpConfigLoader.logConfigVersion(this.otpConfig.configVersion, this.buildConfig.configVersion, this.routerConfig.getConfigVersion());
    }

    public OtpConfig otpConfig() {
        return this.otpConfig;
    }

    public BuildConfig buildConfig() {
        return this.buildConfig;
    }

    public RouterConfig routerConfig() {
        return this.routerConfig;
    }

    public DebugUiConfig debugUiConfig() {
        return this.debugUiConfig;
    }

    public static void initializeOtpFeatures(OtpConfig otpConfig) {
        OTPFeature.enableFeatures(otpConfig.otpFeatures);
        OTPFeature.logFeatureSetup();
    }

    public void abortOnUnknownParameters() {
        if (this.otpConfig.hasUnknownParameters() || this.buildConfig.hasUnknownParameters() || this.routerConfig.hasUnknownParameters() || this.debugUiConfig.hasUnknownParameters()) {
            throw new OtpAppException("Configuration contains unknown parameters (see above for details). Please fix your configuration or remove --abortOnUnknownConfig from your OTP CLI parameters.");
        }
    }
}

