/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.api;

import graphql.schema.GraphQLSchema;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.List;
import javax.annotation.Nullable;
import org.opentripplanner.apis.gtfs.GtfsApiParameters;
import org.opentripplanner.apis.transmodel.TransmodelAPIParameters;
import org.opentripplanner.astar.spi.TraverseVisitor;
import org.opentripplanner.ext.dataoverlay.routing.DataOverlayContext;
import org.opentripplanner.ext.flex.FlexParameters;
import org.opentripplanner.ext.geocoder.LuceneIndex;
import org.opentripplanner.ext.ridehailing.RideHailingService;
import org.opentripplanner.ext.sorlandsbanen.SorlandsbanenNorwayService;
import org.opentripplanner.ext.stopconsolidation.StopConsolidationService;
import org.opentripplanner.ext.trias.parameters.TriasApiParameters;
import org.opentripplanner.framework.application.OTPFeature;
import org.opentripplanner.raptor.api.request.RaptorTuningParameters;
import org.opentripplanner.raptor.configure.RaptorConfig;
import org.opentripplanner.routing.algorithm.filterchain.framework.spi.ItineraryDecorator;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TransitTuningParameters;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripSchedule;
import org.opentripplanner.routing.api.RoutingService;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.fares.FareService;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graphfinder.GraphFinder;
import org.opentripplanner.routing.linking.VertexLinker;
import org.opentripplanner.routing.via.ViaCoordinateTransferFactory;
import org.opentripplanner.service.realtimevehicles.RealtimeVehicleService;
import org.opentripplanner.service.vehicleparking.VehicleParkingService;
import org.opentripplanner.service.vehiclerental.VehicleRentalService;
import org.opentripplanner.service.worldenvelope.WorldEnvelopeService;
import org.opentripplanner.standalone.config.DebugUiConfig;
import org.opentripplanner.standalone.config.routerconfig.VectorTileConfig;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.search.state.State;
import org.opentripplanner.street.service.StreetLimitationParametersService;
import org.opentripplanner.transit.service.TransitService;

public interface OtpServerRequestContext {
    public DebugUiConfig debugUiConfig();

    public RouteRequest defaultRouteRequest();

    public RaptorConfig<TripSchedule> raptorConfig();

    public Graph graph();

    public TransitService transitService();

    public RoutingService routingService();

    public WorldEnvelopeService worldEnvelopeService();

    public RealtimeVehicleService realtimeVehicleService();

    public VehicleRentalService vehicleRentalService();

    public VehicleParkingService vehicleParkingService();

    public TransitTuningParameters transitTuningParameters();

    public RaptorTuningParameters raptorTuningParameters();

    public List<RideHailingService> rideHailingServices();

    public StreetLimitationParametersService streetLimitationParametersService();

    public MeterRegistry meterRegistry();

    public TraverseVisitor<State, Edge> traverseVisitor();

    default public GraphFinder graphFinder() {
        return GraphFinder.getInstance(this.graph(), this.vertexLinker(), this.transitService()::findRegularStopsByBoundingBox);
    }

    public FlexParameters flexParameters();

    public VectorTileConfig vectorTileConfig();

    public ViaCoordinateTransferFactory viaTransferResolver();

    public TriasApiParameters triasApiParameters();

    public GtfsApiParameters gtfsApiParameters();

    public TransmodelAPIParameters transmodelAPIParameters();

    @Nullable
    default public DataOverlayContext dataOverlayContext(RouteRequest request) {
        return OTPFeature.DataOverlay.isOnElseNull(() -> new DataOverlayContext(this.graph().dataOverlayParameterBindings, request.preferences().system().dataOverlay()));
    }

    @Nullable
    public ItineraryDecorator emissionItineraryDecorator();

    @Nullable
    public LuceneIndex lucenceIndex();

    @Nullable
    public StopConsolidationService stopConsolidationService();

    @Nullable
    public SorlandsbanenNorwayService sorlandsbanenService();

    @Nullable
    public GraphQLSchema gtfsSchema();

    @Nullable
    public GraphQLSchema transmodelSchema();

    public FareService fareService();

    public VertexLinker vertexLinker();
}

