/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import org.geotools.referencing.factory.DeferredAuthorityFactory;
import org.geotools.util.WeakCollectionCleaner;
import org.opentripplanner.framework.application.ApplicationShutdownSupport;
import org.opentripplanner.framework.application.OtpAppException;
import org.opentripplanner.graph_builder.GraphBuilder;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueSummary;
import org.opentripplanner.model.projectinfo.OtpProjectInfo;
import org.opentripplanner.raptor.configure.RaptorConfig;
import org.opentripplanner.routing.graph.SerializedGraphObject;
import org.opentripplanner.standalone.OtpStartupInfo;
import org.opentripplanner.standalone.config.CommandLineParameters;
import org.opentripplanner.standalone.config.ConfigModel;
import org.opentripplanner.standalone.configure.ConstructApplication;
import org.opentripplanner.standalone.configure.LoadApplication;
import org.opentripplanner.standalone.server.GrizzlyServer;
import org.opentripplanner.transit.service.TimetableRepository;
import org.opentripplanner.updater.configure.UpdaterConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class OTPMain {
    private static final Logger LOG = LoggerFactory.getLogger(OTPMain.class);

    public static void main(String[] args) {
        try {
            Thread.currentThread().setName("main");
            CommandLineParameters params = OTPMain.parseAndValidateCmdLine(args);
            OtpStartupInfo.logInfo(params.logTaskInfo());
            OTPMain.startOTPServer(params);
        }
        catch (OtpAppException ae) {
            LOG.error(ae.getMessage(), (Throwable)ae);
            System.exit(100);
        }
        catch (Exception e) {
            LOG.error("An uncaught error occurred inside OTP: {}", (Object)e.getLocalizedMessage(), (Object)e);
            System.exit(-1);
        }
    }

    private static CommandLineParameters parseAndValidateCmdLine(String[] args) {
        CommandLineParameters params = new CommandLineParameters();
        try {
            JCommander jc = JCommander.newBuilder().addObject((Object)params).args(args).build();
            if (params.version) {
                System.out.println("OpenTripPlanner " + OtpProjectInfo.projectInfo().getVersionString());
                System.exit(0);
            }
            if (params.serializationVersionId) {
                System.out.println(OtpProjectInfo.projectInfo().getOtpSerializationVersionId());
                System.exit(0);
            }
            if (params.help) {
                System.out.println("OpenTripPlanner " + OtpProjectInfo.projectInfo().getVersionString());
                jc.setProgramName("java -Xmx4G -jar otp.jar");
                jc.usage();
                System.exit(0);
            }
            params.inferAndValidate();
        }
        catch (ParameterException pex) {
            LOG.error("Parameter error: {}", (Object)pex.getMessage());
            System.exit(1);
        }
        return params;
    }

    private static void startOTPServer(CommandLineParameters cli) {
        ConstructApplication app;
        boolean graphAvailable = false;
        LOG.info("Searching for configuration and input files in {}", (Object)cli.getBaseDirectory().getAbsolutePath());
        LoadApplication loadApp = new LoadApplication(cli);
        ConfigModel config = loadApp.config();
        OTPMain.detectUnusedConfigParams(cli, config);
        loadApp.validateConfigAndDataSources();
        if (cli.doLoadGraph() || cli.doLoadStreetGraph()) {
            SerializedGraphObject obj = SerializedGraphObject.load(loadApp.getInputGraphDataStore());
            app = loadApp.appConstruction(obj);
            config.updateConfigFromSerializedGraph(obj.buildConfig, obj.routerConfig);
            graphAvailable = true;
        } else {
            app = loadApp.appConstruction();
        }
        if (cli.doBuildStreet() || cli.doBuildTransit()) {
            SerializedGraphObject.verifyTheOutputGraphIsWritableIfDataSourceExist(app.graphOutputDataSource());
            GraphBuilder graphBuilder = app.createGraphBuilder();
            graphBuilder.run();
            graphAvailable = true;
            new SerializedGraphObject(app.graph(), app.osmInfoGraphBuildRepository(), app.timetableRepository(), app.worldEnvelopeRepository(), app.vehicleParkingRepository(), config.buildConfig(), config.routerConfig(), DataImportIssueSummary.combine(graphBuilder.issueSummary(), app.dataImportIssueSummary()), app.emissionRepository(), app.stopConsolidationRepository(), app.streetLimitationParameters(), app.fareServiceFactory()).save(app.graphOutputDataSource());
            LOG.info("Memory optimized {}", (Object)app.graph().deduplicator.toString());
        }
        if (!graphAvailable) {
            LOG.error("Nothing to do, no graph loaded or build. Exiting.");
            System.exit(101);
        }
        if (cli.doServe()) {
            OTPMain.startOtpWebServer(cli, app);
        } else {
            LOG.info("Done building graph. Exiting.");
        }
    }

    private static void detectUnusedConfigParams(CommandLineParameters cli, ConfigModel config) {
        if (cli.abortOnUnknownConfig) {
            config.abortOnUnknownParameters();
        }
    }

    private static void startOtpWebServer(CommandLineParameters params, ConstructApplication app) {
        app.timetableRepository().index();
        app.graph().index();
        OTPMain.setOtpConfigVersionsOnServerInfo(app);
        if (params.visualize) {
            app.graphVisualizer().run();
        }
        if (params.doServe()) {
            GrizzlyServer grizzlyServer = app.createGrizzlyServer();
            OTPMain.registerShutdownHookToGracefullyShutDownServer(app.timetableRepository(), app.raptorConfig());
            while (true) {
                try {
                    grizzlyServer.run();
                    return;
                }
                catch (Throwable throwable) {
                    LOG.error("An uncaught error occurred inside OTP. Restarting server. Error was: {}", (Object)throwable.getMessage(), (Object)throwable);
                    continue;
                }
                break;
            }
        }
    }

    private static void registerShutdownHookToGracefullyShutDownServer(TimetableRepository timetableRepository, RaptorConfig<?> raptorConfig) {
        ApplicationShutdownSupport.addShutdownHook("server-shutdown", () -> {
            LOG.info("OTP shutdown started...");
            UpdaterConfigurator.shutdownGraph(timetableRepository);
            raptorConfig.shutdown();
            WeakCollectionCleaner.DEFAULT.exit();
            DeferredAuthorityFactory.exit();
            LOG.info("OTP shutdown: resources released...");
        });
    }

    private static void setOtpConfigVersionsOnServerInfo(ConstructApplication app) {
        OtpProjectInfo.projectInfo().otpConfigVersion = app.otpConfig().configVersion;
        OtpProjectInfo.projectInfo().buildConfigVersion = app.buildConfig().configVersion;
        OtpProjectInfo.projectInfo().routerConfigVersion = app.routerConfig().getConfigVersion();
    }

    static {
        System.setProperty("hsqldb.reconfig_logging", "false");
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
    }
}

