/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.service.worldenvelope.model;

import java.util.Collection;
import java.util.function.Function;
import org.opentripplanner.framework.geometry.WgsCoordinate;
import org.opentripplanner.service.worldenvelope.model.MedianCalcForDoubles;
import org.opentripplanner.service.worldenvelope.model.WorldEnvelope;

public class WorldEnvelopeBuilder {
    private static final Double MIN_NOT_SET = 9999.0;
    private static final Double MAX_NOT_SET = -9999.0;
    private static final WgsCoordinate A_PLACE_IN_EUROPE = new WgsCoordinate(47.101, 9.611);
    private double minLat = MIN_NOT_SET;
    private double maxLat = MAX_NOT_SET;
    private double minLonWest = MIN_NOT_SET;
    private double maxLonWest = MAX_NOT_SET;
    private double minLonEast = MIN_NOT_SET;
    private double maxLonEast = MAX_NOT_SET;
    private WgsCoordinate transitMedianCenter = null;

    public WorldEnvelopeBuilder expandToIncludeStreetEntities(double latitude, double longitude) {
        return this.expandToInclude(latitude, longitude);
    }

    public <T> WorldEnvelopeBuilder expandToIncludeTransitEntities(Collection<T> collection, Function<T, Double> latProvider, Function<T, Double> lonProvider) {
        if (collection.isEmpty()) {
            return this;
        }
        for (Object object : collection) {
            this.expandToInclude(latProvider.apply(object), lonProvider.apply(object));
        }
        MedianCalcForDoubles medianCalculator = new MedianCalcForDoubles(collection.size());
        double d = 0.0;
        if (this.includeLongitude180()) {
            collection.forEach(v -> {
                double c = (Double)lonProvider.apply(v);
                if (c < 0.0) {
                    c += 360.0;
                }
                medianCalculator.add(c);
            });
            d = medianCalculator.median();
            if (d > 180.0) {
                d -= 180.0;
            }
        } else {
            collection.forEach(v -> medianCalculator.add((Double)lonProvider.apply(v)));
            d = medianCalculator.median();
        }
        medianCalculator.reset();
        collection.forEach(v -> medianCalculator.add((Double)latProvider.apply(v)));
        double lat = medianCalculator.median();
        this.transitMedianCenter = new WgsCoordinate(lat, d);
        return this;
    }

    public WorldEnvelope build() {
        if (this.minLonWest == MIN_NOT_SET && this.minLonEast == MIN_NOT_SET) {
            return new WorldEnvelope(-90.0, -180.0, 90.0, 180.0, A_PLACE_IN_EUROPE);
        }
        if (this.minLonWest == MIN_NOT_SET) {
            return new WorldEnvelope(this.minLat, this.minLonEast, this.maxLat, this.maxLonEast, this.transitMedianCenter);
        }
        if (this.minLonEast == MIN_NOT_SET) {
            return new WorldEnvelope(this.minLat, this.minLonWest, this.maxLat, this.maxLonWest, this.transitMedianCenter);
        }
        if (this.includeLongitude180()) {
            return new WorldEnvelope(this.minLat, this.minLonEast, this.maxLat, this.minLonWest, this.transitMedianCenter);
        }
        return new WorldEnvelope(this.minLat, this.minLonWest, this.maxLat, this.maxLonEast, this.transitMedianCenter);
    }

    boolean includeLongitude180() {
        if (this.minLonWest == MIN_NOT_SET || this.minLonEast == MIN_NOT_SET) {
            return false;
        }
        double dist180 = 360.0 - this.maxLonEast + this.minLonWest;
        double dist0 = this.minLonEast - this.minLonWest;
        return dist180 < dist0;
    }

    private WorldEnvelopeBuilder expandToInclude(double latitude, double longitude) {
        this.minLat = Math.min(this.minLat, latitude);
        this.maxLat = Math.max(this.maxLat, latitude);
        if (longitude < 0.0) {
            this.minLonWest = Math.min(this.minLonWest, longitude);
            this.maxLonWest = Math.max(this.maxLonWest, longitude);
        } else {
            this.minLonEast = Math.min(this.minLonEast, longitude);
            this.maxLonEast = Math.max(this.maxLonEast, longitude);
        }
        return this;
    }
}

