/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.service.worldenvelope.model;

import java.io.Serializable;
import java.util.Optional;
import org.opentripplanner.framework.geometry.WgsCoordinate;
import org.opentripplanner.service.worldenvelope.model.WorldEnvelopeBuilder;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public class WorldEnvelope
implements Serializable {
    private final WgsCoordinate lowerLeft;
    private final WgsCoordinate upperRight;
    private final WgsCoordinate meanCenter;
    private final WgsCoordinate transitMedianCenter;

    private WorldEnvelope(WgsCoordinate lowerLeft, WgsCoordinate upperRight, WgsCoordinate transitMedianCenter) {
        this.transitMedianCenter = transitMedianCenter;
        this.lowerLeft = lowerLeft;
        this.upperRight = upperRight;
        this.meanCenter = WorldEnvelope.calculateMeanCenter(lowerLeft, upperRight);
    }

    WorldEnvelope(double lowerLeftLatitude, double lowerLeftLongitude, double upperRightLatitude, double upperRightLongitude, WgsCoordinate transitMedianCenter) {
        this(new WgsCoordinate(lowerLeftLatitude, lowerLeftLongitude), new WgsCoordinate(upperRightLatitude, upperRightLongitude), transitMedianCenter);
    }

    public static WorldEnvelopeBuilder of() {
        return new WorldEnvelopeBuilder();
    }

    public WgsCoordinate lowerLeft() {
        return this.lowerLeft;
    }

    public WgsCoordinate upperRight() {
        return this.upperRight;
    }

    public WgsCoordinate center() {
        return this.medianCenter().orElse(this.meanCenter);
    }

    public WgsCoordinate meanCenter() {
        return this.meanCenter;
    }

    public Optional<WgsCoordinate> medianCenter() {
        return Optional.ofNullable(this.transitMedianCenter);
    }

    public String toString() {
        return ToStringBuilder.of(WorldEnvelope.class).addObj("lowerLeft", (Object)this.lowerLeft).addObj("upperRight", (Object)this.upperRight).addObj("meanCenter", (Object)this.meanCenter).addObj("transitMedianCenter", (Object)this.transitMedianCenter).toString();
    }

    private static WgsCoordinate calculateMeanCenter(WgsCoordinate lowerLeft, WgsCoordinate upperRight) {
        double llLatitude = lowerLeft.latitude();
        double llLongitude = lowerLeft.longitude();
        double urLatitude = upperRight.latitude();
        double urLongitude = upperRight.longitude();
        double centerLatitude = llLatitude + (urLatitude - llLatitude) / 2.0;
        double centerLongitude = llLongitude < urLongitude ? llLongitude + (urLongitude - llLongitude) / 2.0 : llLongitude + (360.0 - llLongitude + urLongitude) / 2.0;
        return new WgsCoordinate(centerLatitude, centerLongitude);
    }
}

