/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.service.worldenvelope.model;

import java.util.Arrays;

class MedianCalcForDoubles {
    private final double[] array;
    private int index = 0;

    public MedianCalcForDoubles(int size) {
        if (size <= 0) {
            throw new IllegalStateException("The set must contain at least one element. n: " + size);
        }
        this.array = new double[size];
    }

    public void add(double v) {
        this.array[this.index++] = v;
    }

    public void reset() {
        this.index = 0;
    }

    public double median() {
        int n = this.array.length;
        if (this.index != n) {
            throw new IllegalStateException("The correct number of values are not added. Index: " + this.index + ", n: " + n);
        }
        Arrays.sort(this.array);
        if (n % 2 == 1) {
            return this.array[(n - 1) / 2];
        }
        int i = n / 2 - 1;
        return (this.array[i] + this.array[i + 1]) / 2.0;
    }
}

