/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.service.vehiclerental.street;

import javax.annotation.Nullable;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.routing.algorithm.mapping.StreetModeToRentalTraverseModeMapper;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.routing.api.request.preference.VehicleRentalPreferences;
import org.opentripplanner.service.vehiclerental.model.VehicleRentalPlace;
import org.opentripplanner.service.vehiclerental.street.VehicleRentalPlaceVertex;
import org.opentripplanner.street.model.RentalFormFactor;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.search.state.State;
import org.opentripplanner.street.search.state.StateEditor;

public class VehicleRentalEdge
extends Edge {
    public final RentalFormFactor formFactor;

    private VehicleRentalEdge(VehicleRentalPlaceVertex vertex, RentalFormFactor formFactor) {
        super(vertex, vertex);
        this.formFactor = formFactor;
    }

    public static VehicleRentalEdge createVehicleRentalEdge(VehicleRentalPlaceVertex vertex, RentalFormFactor formFactor) {
        return VehicleRentalEdge.connectToGraph(new VehicleRentalEdge(vertex, formFactor));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public State[] traverse(State s0) {
        boolean pickedUp;
        VehicleRentalPreferences preferences;
        StateEditor s1;
        block25: {
            boolean realtimeAvailability;
            String network;
            VehicleRentalPlace station;
            block24: {
                if (!s0.getRequest().mode().includesRenting()) {
                    return State.empty();
                }
                if (!VehicleRentalEdge.isFormFactorAllowed(s0.getRequest().mode(), this.formFactor)) {
                    return State.empty();
                }
                s1 = s0.edit(this);
                VehicleRentalPlaceVertex stationVertex = (VehicleRentalPlaceVertex)this.tov;
                station = stationVertex.getStation();
                network = station.network();
                preferences = s0.getPreferences().rental(this.formFactor.traverseMode);
                realtimeAvailability = preferences.useAvailabilityInformation();
                if (station.networkIsNotAllowed(preferences)) {
                    return State.empty();
                }
                if (!s0.getRequest().arriveBy()) break block24;
                switch (s0.getVehicleRentalState()) {
                    case BEFORE_RENTING: {
                        return State.empty();
                    }
                    case HAVE_RENTED: {
                        if (!station.canDropOffFormFactor(this.formFactor, realtimeAvailability)) {
                            return State.empty();
                        }
                        s1.dropOffRentedVehicleAtStation(this.formFactor, network, true);
                        pickedUp = false;
                        break block25;
                    }
                    case RENTING_FLOATING: {
                        if (s0.stateData.noRentalDropOffZonesAtStartOfReverseSearch.contains(network) || !station.availablePickupFormFactors(realtimeAvailability).contains((Object)this.formFactor)) {
                            return State.empty();
                        }
                        if (!station.isFloatingVehicle()) return State.empty();
                        s1.beginFloatingVehicleRenting(this.formFactor, network, true);
                        pickedUp = true;
                        break block25;
                    }
                    case RENTING_FROM_STATION: {
                        if (realtimeAvailability && !station.allowPickupNow() || !station.availablePickupFormFactors(realtimeAvailability).contains((Object)this.formFactor)) {
                            return State.empty();
                        }
                        if (s0.mayKeepRentedVehicleAtDestination() && !station.isArrivingInRentalVehicleAtDestinationAllowed()) {
                            return State.empty();
                        }
                        if (!this.hasCompatibleNetworks(network, s0.getVehicleRentalNetwork())) {
                            return State.empty();
                        }
                        s1.beginVehicleRentingAtStation(this.formFactor, network, false, true);
                        pickedUp = true;
                        break block25;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            switch (s0.getVehicleRentalState()) {
                case BEFORE_RENTING: {
                    if (realtimeAvailability && !station.allowPickupNow() || !station.availablePickupFormFactors(realtimeAvailability).contains((Object)this.formFactor)) {
                        return State.empty();
                    }
                    if (station.isFloatingVehicle()) {
                        s1.beginFloatingVehicleRenting(this.formFactor, network, false);
                    } else {
                        boolean mayKeep = preferences.allowArrivingInRentedVehicleAtDestination() && station.isArrivingInRentalVehicleAtDestinationAllowed();
                        s1.beginVehicleRentingAtStation(this.formFactor, network, mayKeep, false);
                    }
                    pickedUp = true;
                    break;
                }
                case HAVE_RENTED: {
                    return State.empty();
                }
                case RENTING_FLOATING: 
                case RENTING_FROM_STATION: {
                    if (!this.hasCompatibleNetworks(network, s0.getVehicleRentalNetwork())) {
                        return State.empty();
                    }
                    if (!station.canDropOffFormFactor(this.formFactor, realtimeAvailability)) {
                        return State.empty();
                    }
                    s1.dropOffRentedVehicleAtStation(this.formFactor, network, false);
                    pickedUp = false;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        s1.incrementWeight(pickedUp ? (double)preferences.pickupCost().toSeconds() : (double)preferences.dropOffCost().toSeconds());
        s1.incrementTimeInMilliseconds(pickedUp ? preferences.pickupTime().toMillis() : preferences.dropOffTime().toMillis());
        s1.setBackMode(null);
        return s1.makeStateArray();
    }

    @Override
    public I18NString getName() {
        return this.getToVertex().getName();
    }

    private boolean hasCompatibleNetworks(String stationNetwork, @Nullable String rentedNetwork) {
        if (rentedNetwork == null) {
            return true;
        }
        return rentedNetwork.equals(stationNetwork);
    }

    private static boolean isFormFactorAllowed(StreetMode streetMode, RentalFormFactor formFactor) {
        return formFactor.traverseMode == StreetModeToRentalTraverseModeMapper.map(streetMode);
    }
}

